/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.tree;

import java.util.function.UnaryOperator;
import kd.bos.flydb.core.sql.dialect.KSQLDialect;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.tree.SqlParserPosition;
import kd.bos.flydb.core.sql.unparse.SqlDialect;
import kd.bos.flydb.core.sql.unparse.SqlPrettyWriter;
import kd.bos.flydb.core.sql.unparse.SqlString;
import kd.bos.flydb.core.sql.unparse.SqlWriter;
import kd.bos.flydb.core.sql.unparse.SqlWriterConfig;
import kd.bos.flydb.core.sql.util.ASTVisitor;
import kd.bos.flydb.core.sql.validate.SqlValidator;
import kd.bos.flydb.core.sql.validate.SqlValidatorScope;

public interface SqlNode {
    public SqlKind getKind();

    public SqlParserPosition getPosition();

    public <T> T accept(ASTVisitor<T> var1);

    public void validate(SqlValidator var1, SqlValidatorScope var2);

    default public boolean isBelong(SqlKind[] category) {
        return this.getKind().isBelong(category);
    }

    default public boolean equalsOnExpression(SqlNode other) {
        return this == other;
    }

    default public <T extends SqlNode> T cast(Class<T> tClass) {
        return (T)((SqlNode)tClass.cast(this));
    }

    public void unParse(SqlWriter var1, int var2, int var3);

    default public SqlString toSqlString(SqlDialect dialect) {
        return this.toSqlString(dialect, false);
    }

    default public SqlString toSqlString(SqlDialect dialect, boolean forceParens) {
        return this.toSqlString(c -> c.withDialect(dialect).withAlwaysUseParentheses(forceParens).withKeywordsLowerCase(false));
    }

    default public SqlString toSqlString(UnaryOperator<SqlWriterConfig> transform) {
        SqlWriterConfig config = (SqlWriterConfig)transform.apply(SqlPrettyWriter.config());
        SqlPrettyWriter writer = new SqlPrettyWriter(config);
        this.unParse(writer, 0, 0);
        return writer.toSqlString();
    }

    default public String toSql() {
        return this.toSqlString(KSQLDialect.DEFAULT).getSql();
    }
}

