/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.tree;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.List;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.sql.operator.SqlOperator;
import kd.bos.flydb.core.sql.operator.SqlOperators;
import kd.bos.flydb.core.sql.tree.SqlCall;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.tree.SqlNode;
import kd.bos.flydb.core.sql.tree.SqlNodeList;
import kd.bos.flydb.core.sql.tree.SqlParserPosition;
import kd.bos.flydb.core.sql.util.ASTVisitor;
import kd.bos.flydb.core.sql.validate.SqlValidator;
import kd.bos.flydb.core.sql.validate.SqlValidatorScope;

public class SqlOrderBy
extends SqlCall {
    public static final int QUERY_OPERAND = 0;
    public static final int ORDER_OPERAND = 1;
    public static final int OFFSET_OPERAND = 2;
    public static final int LIMIT_OPERAND = 3;
    private static final int OPERAND_COUNT = 4;
    private SqlNode query;
    private SqlNodeList orderList;
    private SqlNode offset;
    private SqlNode limit;
    private final SqlOperator sqlOperator = SqlOperators.of(SqlKind.ORDER_BY);

    public SqlOrderBy(SqlParserPosition position, SqlNode query, SqlNodeList orderList, SqlNode offset, SqlNode limit) {
        super(position, SqlKind.ORDER_BY);
        this.query = query;
        this.orderList = orderList;
        this.offset = offset;
        this.limit = limit;
    }

    @Override
    public int getOperandCount() {
        return 4;
    }

    @Override
    public SqlNode getOperand(int i) {
        switch (i) {
            case 0: {
                return this.query;
            }
            case 1: {
                return this.orderList;
            }
            case 2: {
                return this.offset;
            }
            case 3: {
                return this.limit;
            }
        }
        throw Exceptions.of((ErrorCode)ErrorCode.Unexpected, (Object[])new Object[0]);
    }

    @Override
    public SqlOperator getOperator() {
        return this.sqlOperator;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return Lists.newArrayList((Object[])new SqlNode[]{this.query, this.orderList, this.offset, this.limit});
    }

    @Override
    public void setOperand(int i, SqlNode node) {
        switch (i) {
            case 0: {
                this.query = node;
                break;
            }
            case 1: {
                this.orderList = (SqlNodeList)node;
                break;
            }
            case 2: {
                this.offset = node;
                break;
            }
            case 3: {
                this.limit = node;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
    }

    @Override
    public <T> T accept(ASTVisitor<T> visitor) {
        return visitor.visitSqlOrderBy(this);
    }

    public SqlNode getQuery() {
        return this.query;
    }

    public SqlNodeList getOrderList() {
        return this.orderList;
    }

    public SqlNode getOffset() {
        return this.offset;
    }

    public SqlNode getLimit() {
        return this.limit;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.query, this.orderList, this.offset, this.limit, this.sqlOperator});
    }
}

