/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.tree;

import com.google.common.collect.Lists;
import java.util.List;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.sql.operator.SqlOperator;
import kd.bos.flydb.core.sql.operator.SqlOperators;
import kd.bos.flydb.core.sql.tree.SqlCall;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.tree.SqlNode;
import kd.bos.flydb.core.sql.tree.SqlNodeList;
import kd.bos.flydb.core.sql.tree.SqlParserPosition;
import kd.bos.flydb.core.sql.unparse.SqlWriter;
import kd.bos.flydb.core.sql.util.ASTVisitor;
import kd.bos.flydb.core.sql.validate.SqlValidator;
import kd.bos.flydb.core.sql.validate.SqlValidatorScope;

public class SqlSelect
extends SqlCall {
    public static final int KEYWORD_OPERAND = 0;
    public static final int SELECT_LIST_OPERAND = 1;
    public static final int FROM_OPERAND = 2;
    public static final int WHERE_OPERAND = 3;
    public static final int GROUP_BY_OPERAND = 4;
    public static final int HAVING_OPERAND = 5;
    public static final int WINDOWS_OPERAND = 6;
    public static final int ORDER_BY_OPERAND = 7;
    public static final int OFFSET_OPERAND = 8;
    public static final int LIMIT_OPERAND = 9;
    public static final int HINTS_OPERAND = 10;
    private static final int OPERAND_COUNT = 11;
    private SqlNodeList keywordList;
    private SqlNodeList selectList;
    private SqlNode from;
    private SqlNode where;
    private SqlNodeList groupBy;
    private SqlNode having;
    private SqlNodeList windowDecls;
    private SqlNodeList orderBy;
    private SqlNode offset;
    private SqlNode limit;
    private SqlNodeList hints;
    private SqlOperator sqlOperator;

    public SqlSelect(SqlParserPosition pos, SqlNode ... nodes) {
        super(pos, SqlKind.SELECT);
        assert (nodes.length == 11);
        for (int i = 0; i < 10; ++i) {
            this.setOperand(i, nodes[i]);
        }
        this.sqlOperator = SqlOperators.of(SqlKind.SELECT);
    }

    public SqlSelect(SqlParserPosition pos, SqlNodeList keywordList, SqlNodeList selectList, SqlNode from, SqlNode where, SqlNodeList groupBy, SqlNode having, SqlNodeList windowDecls, SqlNodeList orderBy, SqlNode offset, SqlNode limit, SqlNodeList hints) {
        this(pos, new SqlNode[]{keywordList, selectList, from, where, groupBy, having, windowDecls, orderBy, offset, limit, hints});
    }

    @Override
    public SqlOperator getOperator() {
        return this.sqlOperator;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return Lists.newArrayList((Object[])new SqlNode[]{this.keywordList, this.selectList, this.from, this.where, this.groupBy, this.having, this.windowDecls, this.orderBy, this.offset, this.limit, this.hints});
    }

    @Override
    public SqlNode getOperand(int i) {
        switch (i) {
            case 0: {
                return this.keywordList;
            }
            case 1: {
                return this.selectList;
            }
            case 2: {
                return this.from;
            }
            case 3: {
                return this.where;
            }
            case 4: {
                return this.groupBy;
            }
            case 5: {
                return this.having;
            }
            case 6: {
                return this.windowDecls;
            }
            case 7: {
                return this.orderBy;
            }
            case 8: {
                return this.offset;
            }
            case 9: {
                return this.limit;
            }
            case 10: {
                return this.hints;
            }
        }
        throw Exceptions.of((ErrorCode)ErrorCode.Unexpected, (Object[])new Object[0]);
    }

    @Override
    public int getOperandCount() {
        return 11;
    }

    @Override
    public final void setOperand(int i, SqlNode operand) {
        switch (i) {
            case 0: {
                this.keywordList = (SqlNodeList)operand;
                break;
            }
            case 1: {
                this.selectList = (SqlNodeList)operand;
                break;
            }
            case 2: {
                this.from = operand;
                break;
            }
            case 3: {
                this.where = operand;
                break;
            }
            case 4: {
                this.groupBy = (SqlNodeList)operand;
                break;
            }
            case 5: {
                this.having = operand;
                break;
            }
            case 6: {
                this.windowDecls = (SqlNodeList)operand;
                break;
            }
            case 7: {
                this.orderBy = (SqlNodeList)operand;
                break;
            }
            case 8: {
                this.offset = operand;
                break;
            }
            case 9: {
                this.limit = operand;
                break;
            }
            case 10: {
                this.hints = (SqlNodeList)operand;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Override
    public <T> T accept(ASTVisitor<T> visitor) {
        return visitor.visitSqlSelect(this);
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        validator.validateSqlSelect(this);
    }

    @Override
    public void unParse(SqlWriter writer, int leftPrecedence, int rightPrecedence) {
        if (!writer.inQuery()) {
            SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.SUB_QUERY, "(", ")");
            writer.getDialect().unParseCall(writer, this, 0, 0);
            writer.endList(frame);
        } else {
            writer.getDialect().unParseCall(writer, this, leftPrecedence, leftPrecedence);
        }
    }

    public SqlNodeList getKeywordList() {
        return this.keywordList;
    }

    public SqlNodeList getSelectList() {
        return this.selectList;
    }

    public SqlNode getFrom() {
        return this.from;
    }

    public SqlNode getWhere() {
        return this.where;
    }

    public SqlNodeList getGroupBy() {
        return this.groupBy;
    }

    public SqlNode getHaving() {
        return this.having;
    }

    public SqlNodeList getWindowDecls() {
        return this.windowDecls;
    }

    public SqlNodeList getOrderBy() {
        return this.orderBy;
    }

    public SqlNode getOffset() {
        return this.offset;
    }

    public SqlNode getLimit() {
        return this.limit;
    }

    public SqlNodeList getHints() {
        return this.hints;
    }
}

