/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.tree;

import com.google.common.collect.Lists;
import java.util.List;
import kd.bos.flydb.core.sql.operator.SqlOperator;
import kd.bos.flydb.core.sql.operator.SqlOperators;
import kd.bos.flydb.core.sql.tree.SqlCall;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.tree.SqlNode;
import kd.bos.flydb.core.sql.tree.SqlParserPosition;
import kd.bos.flydb.core.sql.util.ASTVisitor;
import kd.bos.flydb.core.sql.validate.SqlValidator;
import kd.bos.flydb.core.sql.validate.SqlValidatorScope;

public class SqlSetVariable
extends SqlCall {
    public static int KEY_OPERAND = 0;
    public static int VALUE_OPERAND = 1;
    private final SqlOperator sqlOperator;
    private SqlNode key;
    private SqlNode value;

    public SqlSetVariable(SqlParserPosition position, SqlNode key, SqlNode value) {
        super(position, SqlKind.SET_SESSION_VARIABLE);
        this.key = key;
        this.value = value;
        this.sqlOperator = SqlOperators.of(SqlKind.SET_SESSION_VARIABLE);
    }

    @Override
    public SqlOperator getOperator() {
        return this.sqlOperator;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return Lists.newArrayList((Object[])new SqlNode[]{this.key, this.value});
    }

    @Override
    public <T> T accept(ASTVisitor<T> visitor) {
        return visitor.visitSqlSetVariable(this);
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        validator.validateSqlSetVariable(this);
    }

    @Override
    public int getOperandCount() {
        return 1;
    }

    @Override
    public SqlNode getOperand(int i) {
        switch (i) {
            case 0: {
                return this.key;
            }
            case 1: {
                return this.value;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void setOperand(int i, SqlNode node) {
        switch (i) {
            case 0: {
                this.key = node;
                return;
            }
            case 1: {
                this.value = node;
                return;
            }
        }
        throw new UnsupportedOperationException();
    }
}

