/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.tree;

import java.util.Arrays;
import java.util.List;
import kd.bos.flydb.core.sql.operator.SqlOperator;
import kd.bos.flydb.core.sql.operator.SqlOperators;
import kd.bos.flydb.core.sql.tree.SqlCall;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.tree.SqlNode;
import kd.bos.flydb.core.sql.tree.SqlParserPosition;
import kd.bos.flydb.core.sql.util.ASTVisitor;
import kd.bos.flydb.core.sql.validate.SqlValidator;
import kd.bos.flydb.core.sql.validate.SqlValidatorScope;

public class SqlShow
extends SqlCall {
    private final SqlOperator sqlOperator;
    public static final int FROM_OPERAND = 0;
    public static final int WHERE_OPERAND = 1;
    private SqlNode from;
    private SqlNode where;

    public SqlShow(SqlParserPosition position, SqlKind sqlKind) {
        super(position, sqlKind);
        this.sqlOperator = SqlOperators.of(sqlKind);
        this.position = position;
    }

    public SqlShow(SqlParserPosition position, SqlKind sqlKind, SqlNode from, SqlNode where) {
        super(position, sqlKind);
        this.position = position;
        this.from = from;
        this.where = where;
        this.sqlOperator = SqlOperators.of(sqlKind);
    }

    @Override
    public SqlOperator getOperator() {
        return this.sqlOperator;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return Arrays.asList(this.from, this.where);
    }

    @Override
    public <T> T accept(ASTVisitor<T> visitor) {
        return visitor.visitSqlShow(this);
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        validator.validateSqlShow(this);
    }

    @Override
    public void setOperand(int i, SqlNode node) {
        switch (i) {
            case 0: {
                this.from = node;
                break;
            }
            case 1: {
                this.where = node;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }
}

