/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.tree;

import com.google.common.collect.Lists;
import java.util.List;
import kd.bos.flydb.core.sql.operator.SqlOperator;
import kd.bos.flydb.core.sql.operator.SqlOperators;
import kd.bos.flydb.core.sql.tree.SqlCall;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.tree.SqlNode;
import kd.bos.flydb.core.sql.tree.SqlParserPosition;
import kd.bos.flydb.core.sql.util.ASTVisitor;
import kd.bos.flydb.core.sql.validate.SqlValidator;
import kd.bos.flydb.core.sql.validate.SqlValidatorScope;

public class SqlShowVariables
extends SqlCall {
    private final SqlOperator sqlOperator;
    private final boolean global;
    private SqlNode pattern;

    public SqlShowVariables(SqlParserPosition position, boolean global, SqlNode pattern) {
        super(position, SqlKind.SHOW_VARIABLES);
        this.global = global;
        this.pattern = pattern;
        this.sqlOperator = SqlOperators.of(SqlKind.SHOW_VARIABLES);
    }

    @Override
    public SqlOperator getOperator() {
        return this.sqlOperator;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return Lists.newArrayList((Object[])new SqlNode[]{this.pattern});
    }

    @Override
    public <T> T accept(ASTVisitor<T> visitor) {
        return visitor.visitSqlShowVariables(this);
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        validator.validateSqlShowVariables(this);
    }

    @Override
    public int getOperandCount() {
        return 1;
    }

    @Override
    public SqlNode getOperand(int i) {
        if (i == 0) {
            return this.pattern;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void setOperand(int i, SqlNode node) {
        if (i != 0) {
            throw new UnsupportedOperationException();
        }
        this.pattern = node;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public SqlNode getPattern() {
        return this.pattern;
    }
}

