/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.type;

import com.google.common.base.Objects;
import java.util.List;
import kd.bos.flydb.core.schema.cosmic.CosmicDataTypeEnum;
import kd.bos.flydb.core.sql.type.DataType;
import kd.bos.flydb.core.sql.type.DataTypeField;
import kd.bos.flydb.core.sql.type.NullDataType;
import kd.bos.flydb.core.sql.type.SqlTypeCategory;
import kd.bos.flydb.core.sql.type.SqlTypeName;

public class BasicDataType
implements DataType {
    private String id;
    private SqlTypeName typeName;
    private int precision;
    private int scale;

    public BasicDataType() {
    }

    public BasicDataType(String id, SqlTypeName typeName, int precision, int scale) {
        this.id = id;
        this.typeName = typeName;
        this.precision = precision;
        this.scale = scale;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public SqlTypeCategory getCategory() {
        return this.typeName.getCategory();
    }

    @Override
    public SqlTypeName getTypeName() {
        return this.typeName;
    }

    @Override
    public int precision() {
        return this.precision;
    }

    @Override
    public int scale() {
        return this.scale;
    }

    @Override
    public boolean isStruct() {
        return false;
    }

    @Override
    public List<DataTypeField> getFieldList() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> getFieldNameList() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getFieldCount() {
        return 0;
    }

    @Override
    public DataTypeField getField(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataTypeField getField(int ordinal) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object o) {
        boolean result;
        if (this == o) {
            return true;
        }
        if (!(o instanceof BasicDataType)) {
            return false;
        }
        BasicDataType that = (BasicDataType)o;
        if (that instanceof NullDataType) {
            return that.equals(this);
        }
        boolean bl = result = Objects.equal((Object)this.id, (Object)that.id) && this.typeName == that.typeName;
        if (result) {
            return true;
        }
        return this.isEqualsMultipleLanguageWithString(that);
    }

    private boolean isEqualsMultipleLanguageWithString(BasicDataType that) {
        if ((CosmicDataTypeEnum.MULTIPLE_LANGUAGE.name().equals(this.id) || CosmicDataTypeEnum.COMMON_MULTIPLE_LANGUAGE.name().equals(this.id)) && that.typeName == SqlTypeName.STRING) {
            return true;
        }
        if (CosmicDataTypeEnum.MULTIPLE_LANGUAGE.name().equals(that.id) || CosmicDataTypeEnum.COMMON_MULTIPLE_LANGUAGE.name().equals(that.id)) {
            return this.typeName == SqlTypeName.STRING;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.typeName, this.precision, this.scale});
    }

    public String toString() {
        return this.id;
    }
}

