/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.type;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeParseException;
import java.util.List;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.interpreter.scalar.BaseScalarEvaluation;
import kd.bos.flydb.core.sql.type.DataTypeField;
import kd.bos.flydb.core.sql.type.SqlTypeCategory;
import kd.bos.flydb.core.sql.type.SqlTypeName;

public interface DataType
extends Serializable {
    public String id();

    public SqlTypeCategory getCategory();

    public SqlTypeName getTypeName();

    public int precision();

    public int scale();

    public boolean isStruct();

    public List<DataTypeField> getFieldList();

    public List<String> getFieldNameList();

    public int getFieldCount();

    public DataTypeField getField(String var1);

    public DataTypeField getField(int var1);

    public static Object convertValue(DataType type, Object value) {
        try {
            if (value == null) {
                return null;
            }
            SqlTypeName typeName = type.getTypeName();
            switch (typeName) {
                case STRING: {
                    if (value instanceof Timestamp) {
                        return BaseScalarEvaluation.DATETIME_FORMATTER.format(LocalDateTime.ofInstant(((Timestamp)value).toInstant(), ZoneId.systemDefault()));
                    }
                    if (value instanceof BigDecimal) {
                        return ((BigDecimal)value).toPlainString();
                    }
                    return value.toString();
                }
                case INT: {
                    if (value instanceof Integer) {
                        return value;
                    }
                    if (value instanceof Number) {
                        return ((Number)value).intValue();
                    }
                    return Integer.valueOf(value.toString());
                }
                case LONG: {
                    if (value instanceof Long) {
                        return value;
                    }
                    if (value instanceof Number) {
                        return ((Number)value).longValue();
                    }
                    return Long.valueOf(value.toString());
                }
                case DECIMAL: {
                    if (value instanceof BigDecimal) {
                        return value;
                    }
                    if (value instanceof Long) {
                        return BigDecimal.valueOf((Long)value);
                    }
                    if (value instanceof Integer) {
                        return BigDecimal.valueOf(((Integer)value).intValue());
                    }
                    if (value instanceof Double) {
                        return BigDecimal.valueOf((Double)value);
                    }
                    return new BigDecimal(value.toString());
                }
                case DATE: {
                    if (value instanceof Date) {
                        return value;
                    }
                    if (value instanceof Timestamp) {
                        return Date.valueOf(((Timestamp)value).toLocalDateTime().toLocalDate());
                    }
                    if (value instanceof Time) {
                        throw Exceptions.of((ErrorCode)ErrorCode.CastError, (Object[])new Object[]{value, "DATE"});
                    }
                    if (value instanceof java.util.Date) {
                        return Date.valueOf(((java.util.Date)value).toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
                    }
                    if (value instanceof String) {
                        try {
                            return Date.valueOf(LocalDate.parse((String)value, BaseScalarEvaluation.DATE_FORMATTER));
                        }
                        catch (DateTimeParseException e) {
                            return Date.valueOf(LocalDateTime.parse((String)value, BaseScalarEvaluation.DATETIME_FORMATTER).toLocalDate());
                        }
                    }
                    throw Exceptions.of((ErrorCode)ErrorCode.CastError, (Object[])new Object[]{value, "DATE"});
                }
                case TIME: {
                    if (value instanceof Time) {
                        return value;
                    }
                    if (value instanceof String) {
                        return Time.valueOf(LocalTime.parse((String)value, BaseScalarEvaluation.TIME_FORMATTER));
                    }
                    throw Exceptions.of((ErrorCode)ErrorCode.CastError, (Object[])new Object[]{value, "TIME"});
                }
                case DATETIME: {
                    if (value instanceof Timestamp) {
                        return value;
                    }
                    if (value instanceof String) {
                        return Timestamp.valueOf(LocalDateTime.parse((String)value, BaseScalarEvaluation.DATETIME_FORMATTER));
                    }
                    throw Exceptions.of((ErrorCode)ErrorCode.CastError, (Object[])new Object[]{value, "DATETIME"});
                }
                case BOOLEAN: {
                    if (value instanceof Boolean) {
                        return value;
                    }
                    if (value instanceof String) {
                        return Boolean.parseBoolean((String)value) || "1".equals(value);
                    }
                    if (value instanceof Number) {
                        return !"0".equals(value.toString());
                    }
                    throw Exceptions.of((ErrorCode)ErrorCode.CastError, (Object[])new Object[]{value, "BOOLEAN"});
                }
            }
            return value;
        }
        catch (Exception e) {
            throw Exceptions.of((ErrorCode)ErrorCode.CastError, (Object[])new Object[]{value, type.getTypeName()});
        }
    }
}

