/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.type;

import java.util.ArrayList;
import java.util.Locale;
import java.util.stream.Collectors;
import kd.bos.flydb.core.sql.type.BasicDataType;
import kd.bos.flydb.core.sql.type.DataType;
import kd.bos.flydb.core.sql.type.DataTypeField;
import kd.bos.flydb.core.sql.type.NullDataType;
import kd.bos.flydb.core.sql.type.SqlTypeName;
import kd.bos.flydb.core.sql.type.TupleDataType;
import kd.bos.flydb.core.sql.util.SqlValidateUtil;

public class DataTypeFactory {
    private static final BasicDataType stringType = new BasicDataType("STRING", SqlTypeName.STRING, -1, -1);
    private static final BasicDataType intType = new BasicDataType("INT", SqlTypeName.INT, 4, -1);
    private static final BasicDataType longType = new BasicDataType("LONG", SqlTypeName.LONG, 8, -1);
    private static final BasicDataType datetimeType = new BasicDataType("DATETIME", SqlTypeName.DATETIME, 8, -1);
    private static final BasicDataType dateType = new BasicDataType("DATE", SqlTypeName.DATE, 4, -1);
    private static final BasicDataType timeType = new BasicDataType("TIME", SqlTypeName.TIME, 4, -1);
    private static final BasicDataType booleanType = new BasicDataType("BOOLEAN", SqlTypeName.BOOLEAN, -1, -1);
    private static final BasicDataType nullType = new NullDataType();
    private static final BasicDataType unknown = new BasicDataType("UNKNOWN", SqlTypeName.UNKNOWN, -1, -1);
    private static final BasicDataType maxDecimalPrecision = new BasicDataType("DECIMAL", SqlTypeName.DECIMAL, 32, 10);
    public static final DataTypeFactory instance = new DataTypeFactory();

    public DataType buildString() {
        return stringType;
    }

    public DataType buildInt() {
        return intType;
    }

    public DataType buildLong() {
        return longType;
    }

    public DataType buildDecimal(int precision, int scale) {
        return new BasicDataType("DECIMAL", SqlTypeName.DECIMAL, precision, scale);
    }

    public DataType buildDatetime() {
        return datetimeType;
    }

    public DataType buildDate() {
        return dateType;
    }

    public DataType buildTime() {
        return timeType;
    }

    public DataType buildBoolean() {
        return booleanType;
    }

    public DataType buildNullType() {
        return nullType;
    }

    public DataType buildUnknownType() {
        return unknown;
    }

    public DataType buildJoinType(DataType left, DataType right) {
        String id = left.id() + "-JOIN-" + right.id();
        ArrayList<String> names = new ArrayList<String>(left.getFieldCount() + right.getFieldCount());
        names.addAll(left.getFieldNameList());
        names.addAll(right.getFieldNameList());
        SqlValidateUtil.renameDuplicate(names);
        ArrayList<DataType> dataTypeList = new ArrayList<DataType>(left.getFieldCount() + right.getFieldCount());
        dataTypeList.addAll(left.getFieldList().stream().map(DataTypeField::getType).collect(Collectors.toList()));
        dataTypeList.addAll(right.getFieldList().stream().map(DataTypeField::getType).collect(Collectors.toList()));
        return new TupleDataType(id, names, dataTypeList);
    }

    public DataType buildByName(String typeName) {
        switch (typeName = typeName.toUpperCase(Locale.ENGLISH)) {
            case "STRING": {
                return stringType;
            }
            case "INT": {
                return intType;
            }
            case "LONG": {
                return longType;
            }
            case "DATETIME": {
                return datetimeType;
            }
            case "TIME": {
                return timeType;
            }
            case "DATE": {
                return dateType;
            }
            case "BOOLEAN": {
                return booleanType;
            }
            case "DECIMAL": {
                return maxDecimalPrecision;
            }
            case "NULL": {
                return nullType;
            }
        }
        throw new UnsupportedOperationException("unsupported type: " + typeName);
    }

    public DataType getMaxPrecisionDecimal() {
        return maxDecimalPrecision;
    }
}

