/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.type;

import java.io.Serializable;
import kd.bos.flydb.core.sql.type.SqlTypeCategory;

public enum SqlTypeName implements Serializable
{
    STRING(2, 12, SqlTypeCategory.STRING),
    INT(2, 4, SqlTypeCategory.NUMBER),
    LONG(2, -5, SqlTypeCategory.NUMBER),
    DECIMAL(4, 3, SqlTypeCategory.NUMBER),
    DATETIME(2, 93, SqlTypeCategory.DATE),
    DATE(2, 91, SqlTypeCategory.DATE),
    TIME(2, 92, SqlTypeCategory.DATE),
    BOOLEAN(1, 16, SqlTypeCategory.BOOLEAN),
    NULL(1, 0, SqlTypeCategory.NULL),
    STRUCT(1, 2002, SqlTypeCategory.COMPLEX),
    UNKNOWN(1, 1111, SqlTypeCategory.UNKNOWN);

    private final int flag;
    private final int jdbcType;
    private final SqlTypeCategory category;

    private SqlTypeName(int flag, int jdbcType, SqlTypeCategory category) {
        this.flag = flag;
        this.jdbcType = jdbcType;
        this.category = category;
    }

    public boolean allowPrecision() {
        return this.flag == 2 || this.flag == 4;
    }

    public boolean allowScale() {
        return this.flag == 4;
    }

    public int getJdbcType() {
        return this.jdbcType;
    }

    public SqlTypeCategory getCategory() {
        return this.category;
    }

    private static interface PrecisionScale {
        public static final int NO_NO = 1;
        public static final int YES_NO = 2;
        public static final int YES_YES = 4;
    }
}

