/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.type;

import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.flydb.core.sql.type.DataType;
import kd.bos.flydb.core.sql.type.DataTypeField;
import kd.bos.flydb.core.sql.type.DataTypeFieldImpl;
import kd.bos.flydb.core.sql.type.SqlTypeCategory;
import kd.bos.flydb.core.sql.type.SqlTypeName;
import kd.bos.flydb.core.sql.util.Assertions;

public class TupleDataType
implements DataType {
    private String id;
    private final Map<String, DataTypeField> fields = new HashMap<String, DataTypeField>(16);
    private final List<String> sortedFieldNames = new ArrayList<String>(16);

    public TupleDataType() {
    }

    public TupleDataType(String id, List<String> fieldNameList, List<DataType> fieldTypeList) {
        this.id = id.toUpperCase();
        Objects.requireNonNull(fieldNameList, "Param fieldNameList can not be null.");
        Objects.requireNonNull(fieldTypeList, "Param fieldTypeList can not be null.");
        Assertions.requireNonNullItem(fieldNameList, "Param fieldNameList can not contain null item.");
        Assertions.requireNonNullItem(fieldTypeList, "Param fieldNameList can not contain null item.");
        Assertions.requireNonDuplicateFieldName(fieldNameList);
        if (fieldNameList.size() != fieldTypeList.size()) {
            throw new IllegalArgumentException("Param fieldNameList must be one-to-one mapping to fieldTypeList.");
        }
        for (int i = 0; i < fieldNameList.size(); ++i) {
            String fieldName = fieldNameList.get(i);
            DataTypeFieldImpl field = new DataTypeFieldImpl(fieldName, i, fieldTypeList.get(i));
            this.fields.put(fieldName, field);
            this.sortedFieldNames.add(fieldName);
        }
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public SqlTypeCategory getCategory() {
        return SqlTypeCategory.COMPLEX;
    }

    @Override
    public SqlTypeName getTypeName() {
        return SqlTypeName.STRUCT;
    }

    @Override
    public int precision() {
        return -1;
    }

    @Override
    public int scale() {
        return -1;
    }

    @Override
    public boolean isStruct() {
        return true;
    }

    @Override
    public List<DataTypeField> getFieldList() {
        return this.sortedFieldNames.stream().map(this.fields::get).collect(Collectors.toList());
    }

    @Override
    public List<String> getFieldNameList() {
        return new ArrayList<String>(this.sortedFieldNames);
    }

    @Override
    public int getFieldCount() {
        return this.fields.size();
    }

    @Override
    public DataTypeField getField(String name) {
        for (Map.Entry<String, DataTypeField> fieldEntry : this.fields.entrySet()) {
            if (!name.equalsIgnoreCase(fieldEntry.getKey())) continue;
            return fieldEntry.getValue();
        }
        return null;
    }

    @Override
    public DataTypeField getField(int ordinal) {
        return this.getField(this.sortedFieldNames.get(ordinal));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) return false;
        if (this.getClass() != o.getClass()) {
            return false;
        }
        TupleDataType that = (TupleDataType)o;
        if (!com.google.common.base.Objects.equal((Object)this.id, (Object)that.id)) return false;
        if (this.sortedFieldNames.size() != that.sortedFieldNames.size()) return false;
        if (!com.google.common.base.Objects.equal(this.sortedFieldNames, that.sortedFieldNames)) return false;
        if (!Iterators.elementsEqual(this.sortedFieldNames.stream().map(this.fields::get).iterator(), that.sortedFieldNames.stream().map(that.fields::get).iterator())) return false;
        return true;
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.id, this.fields, this.sortedFieldNames});
    }

    public String toString() {
        List joins = this.getFieldList().stream().map(Object::toString).collect(Collectors.toList());
        return '(' + String.join((CharSequence)",", joins) + ')';
    }
}

