/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.type;

import java.util.List;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.schema.cosmic.CosmicDataTypeEnum;
import kd.bos.flydb.core.schema.cosmic.CosmicMappingDataType;
import kd.bos.flydb.core.sql.operator.SqlOperators;
import kd.bos.flydb.core.sql.tree.SqlBasicCall;
import kd.bos.flydb.core.sql.tree.SqlCall;
import kd.bos.flydb.core.sql.tree.SqlDynamicParam;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.tree.SqlLiteral;
import kd.bos.flydb.core.sql.tree.SqlNode;
import kd.bos.flydb.core.sql.tree.SqlNodeList;
import kd.bos.flydb.core.sql.tree.SqlParserPosition;
import kd.bos.flydb.core.sql.type.BasicDataType;
import kd.bos.flydb.core.sql.type.DataType;
import kd.bos.flydb.core.sql.type.DataTypeFactory;
import kd.bos.flydb.core.sql.type.SqlTypeCategory;
import kd.bos.flydb.core.sql.type.SqlTypeName;
import kd.bos.flydb.core.sql.validate.SqlValidator;
import kd.bos.flydb.core.sql.validate.SqlValidatorScope;

public class TypeCoercion {
    public void arithmeticCoercion(SqlValidatorScope scope, SqlCall call) {
        if (call.getKind().isBelong(SqlKind.ARITHMETICS)) {
            DataType rightType;
            SqlValidator sqlValidator = scope.getSqlValidator();
            DataTypeFactory dataTypeFactory = sqlValidator.getTypeFactory();
            SqlNode leftNode = call.getOperand(0);
            SqlNode rightNode = call.getOperand(1);
            DataType leftType = sqlValidator.inferDataType(leftNode, scope);
            DataType targetType = this.commonTypeForArithmetic(leftType, rightType = sqlValidator.inferDataType(rightNode, scope), dataTypeFactory);
            if (targetType != null) {
                for (int i = 0; i < call.getOperandList().size(); ++i) {
                    this.coerceOperandType(scope, call, i, targetType);
                }
            }
        }
    }

    public void binaryComparisonCoercion(SqlValidatorScope scope, SqlCall call) {
        if (call.getKind().isBelong(SqlKind.COMPARISON_KINDS)) {
            int i;
            DataType targetType;
            SqlValidator sqlValidator = scope.getSqlValidator();
            DataTypeFactory dataTypeFactory = sqlValidator.getTypeFactory();
            SqlNode leftNode = call.getOperand(0);
            SqlNode rightNode = call.getOperand(1);
            DataType leftType = sqlValidator.inferDataType(leftNode, scope);
            DataType rightType = sqlValidator.inferDataType(rightNode, scope);
            if (leftType.getClass().isAssignableFrom(BasicDataType.class) && leftType instanceof BasicDataType && (targetType = this.commonTypeForBinaryComparison(leftType, rightType, dataTypeFactory)) != null) {
                for (i = 0; i < call.getOperandList().size(); ++i) {
                    this.coerceOperandType(scope, call, i, targetType);
                }
            }
            if (leftType instanceof CosmicMappingDataType && (CosmicDataTypeEnum.BASE_DATA == CosmicDataTypeEnum.valueOf(leftType.id()) || CosmicDataTypeEnum.MULTIPLE_BASE_DATA == CosmicDataTypeEnum.valueOf(leftType.id()))) {
                targetType = this.commonTypeForBinaryComparison(leftType, rightType, dataTypeFactory);
                if ((targetType = DataTypeFactory.instance.buildByName(targetType.getTypeName().name())) != null) {
                    for (i = 0; i < call.getOperandList().size(); ++i) {
                        this.coerceOperandType(scope, call, i, targetType);
                    }
                }
            }
        }
    }

    public DataType commonTypeForArithmetic(DataType type1, DataType type2, DataTypeFactory dataTypeFactory) {
        if (type1 == null || type2 == null) {
            return null;
        }
        if (type1.getTypeName() == type2.getTypeName()) {
            return type1;
        }
        if (type1.getCategory() == SqlTypeCategory.STRING && type2.getCategory() == SqlTypeCategory.NUMBER) {
            return type2;
        }
        if (type2.getCategory() == SqlTypeCategory.STRING && type1.getCategory() == SqlTypeCategory.NUMBER) {
            return type1;
        }
        return null;
    }

    public DataType higherPrecision4NumberType(DataType type1, DataType type2) {
        if (type1.getCategory() != SqlTypeCategory.NUMBER || type2.getCategory() != SqlTypeCategory.NUMBER) {
            return null;
        }
        if (type1.getTypeName() == SqlTypeName.DECIMAL || type2.getTypeName() == SqlTypeName.DECIMAL) {
            return type1.getTypeName() == SqlTypeName.DECIMAL ? type1 : type2;
        }
        if (type1.getTypeName() == SqlTypeName.LONG) {
            if (type2.getTypeName() == SqlTypeName.INT) {
                return type1;
            }
            return type2;
        }
        if (type2.getTypeName() == SqlTypeName.LONG) {
            if (type1.getTypeName() == SqlTypeName.INT) {
                return type2;
            }
            return type1;
        }
        if (type1.getTypeName() == SqlTypeName.INT || type2.getTypeName() == SqlTypeName.INT) {
            return type1.getTypeName() == SqlTypeName.INT ? type2 : type1;
        }
        return null;
    }

    public DataType commonTypeForBinaryComparison(DataType left, DataType right, DataTypeFactory dataTypeFactory) {
        if (left == null || right == null) {
            return null;
        }
        if (left.getTypeName() == right.getTypeName()) {
            return left;
        }
        if (left.getCategory() == SqlTypeCategory.DATE && right.getCategory() == SqlTypeCategory.STRING) {
            return left;
        }
        if (left.getCategory() == SqlTypeCategory.STRING && (right.getCategory() == SqlTypeCategory.NUMBER || right.getCategory() == SqlTypeCategory.DATE)) {
            return left;
        }
        if (left.getCategory() == SqlTypeCategory.NUMBER && right.getCategory() == SqlTypeCategory.STRING) {
            return left;
        }
        if (left.getCategory() == SqlTypeCategory.NUMBER && right.getCategory() == SqlTypeCategory.NUMBER) {
            return left;
        }
        return null;
    }

    private boolean coerceOperandType(SqlValidatorScope scope, SqlCall call, int index, DataType targetType) {
        SqlNode operand = call.getOperand(index);
        SqlValidator sqlValidator = scope.getSqlValidator();
        if (operand instanceof SqlDynamicParam) {
            return false;
        }
        DataType fromType = scope.getSqlValidator().inferDataType(operand, scope);
        if (fromType.getTypeName() == targetType.getTypeName()) {
            return false;
        }
        if (operand.getKind() == SqlKind.FUNC_CAST) {
            SqlNode expression = operand.cast(SqlCall.class).getOperand(0);
            DataType expressionType = sqlValidator.inferDataType(expression, scope);
            if (expressionType.getTypeName() == targetType.getTypeName()) {
                call.setOperand(index, expression);
                return true;
            }
            operand = expression;
        }
        DataTypeFactory dataTypeFactory = sqlValidator.getTypeFactory();
        SqlLiteral typeName = new SqlLiteral(operand.getPosition(), targetType.id(), dataTypeFactory.buildString());
        SqlBasicCall cast = new SqlBasicCall(operand.getPosition(), SqlKind.FUNC_CAST, SqlOperators.of(SqlKind.FUNC_CAST), operand, typeName);
        call.setOperand(index, cast);
        scope.getSqlValidator().setValidateNodeType(cast, targetType);
        return true;
    }

    public void mathFunctionCoercion(SqlValidatorScope scope, SqlCall call) {
        if (call.getKind().isBelong(SqlKind.MATH_FUNCTIONS)) {
            List<SqlNode> operandList = call.getOperandList();
            SqlValidator sqlValidator = scope.getSqlValidator();
            int size = operandList.size();
            SqlNode sqlNode = operandList.get(0);
            this.mathFunctionTypeCoercion(scope, call, sqlValidator, sqlNode, 0);
            if (size == 2) {
                sqlNode = operandList.get(1);
                this.mathFunctionTypeCoercion(scope, call, sqlValidator, sqlNode, 1);
            }
        }
    }

    private void mathFunctionTypeCoercion(SqlValidatorScope scope, SqlCall call, SqlValidator sqlValidator, SqlNode sqlNode, int index) {
        DataType target;
        DataType dataType = sqlValidator.inferDataType(sqlNode, scope);
        DataType targetType = this.targetTypeForMathFunction(dataType, target = DataTypeFactory.instance.getMaxPrecisionDecimal());
        if (targetType == null) {
            throw Exceptions.of((ErrorCode)ErrorCode.FunctionIncompatibleParam, (SqlParserPosition)call.getPosition(), (Object[])new Object[]{call.getKind().name()});
        }
        this.coerceOperandType(scope, call, index, targetType);
    }

    private DataType targetTypeForMathFunction(DataType dataType, DataType target) {
        if (dataType == null) {
            return null;
        }
        if (dataType.getTypeName() == target.getTypeName()) {
            return dataType;
        }
        if (dataType.getCategory() == SqlTypeCategory.STRING) {
            return target;
        }
        if (dataType.getCategory() == SqlTypeCategory.NUMBER) {
            return dataType;
        }
        return null;
    }

    public void logicCoercion(SqlValidatorScope scope, SqlCall call) {
        if (call.getKind().isBelong(SqlKind.LOGIC_OP_KINDS)) {
            List<SqlNode> operandList = call.getOperandList();
            SqlBasicCall basicCall = call.cast(SqlBasicCall.class);
            SqlValidator sqlValidator = scope.getSqlValidator();
            DataType targetType = sqlValidator.getTypeFactory().buildBoolean();
            for (int i = 0; i < operandList.size(); ++i) {
                SqlNode sqlNode = basicCall.getOperand(i);
                DataType dataType = sqlValidator.inferDataType(sqlNode, scope);
                if (dataType != null && dataType.getCategory() == SqlTypeCategory.DATE) {
                    throw Exceptions.of((ErrorCode)ErrorCode.OperatorIncompatibleOperand, (SqlParserPosition)call.getPosition(), (Object[])new Object[]{call.getKind().name(), dataType.id()});
                }
                if (dataType == null) continue;
                this.coerceOperandType(scope, call, i, targetType);
            }
        }
    }

    public void inListCoercion(SqlValidatorScope scope, SqlCall call) {
        if (call.getKind().isBelong(SqlKind.IN_KINDS)) {
            SqlValidator sqlValidator = scope.getSqlValidator();
            SqlNode leftNode = call.getOperand(0);
            SqlNode rightNode = call.getOperand(1);
            DataType targetType = sqlValidator.inferDataType(leftNode, scope);
            if (rightNode instanceof SqlNodeList) {
                SqlNodeList nodeList = rightNode.cast(SqlNodeList.class);
                for (int i = 0; i < nodeList.size(); ++i) {
                    SqlNode sqlNode = nodeList.get(i);
                    DataType dataType = sqlValidator.inferDataType(sqlNode, scope);
                    if (dataType == null) continue;
                    if (targetType.getCategory() == SqlTypeCategory.DATE && dataType.getCategory() == SqlTypeCategory.NUMBER) {
                        throw Exceptions.of((ErrorCode)ErrorCode.TypeCoercionError, (SqlParserPosition)sqlNode.getPosition(), (Object[])new Object[]{dataType.id(), targetType.id()});
                    }
                    this.coerceInListOperandType(scope, nodeList, i, targetType);
                }
            }
        }
    }

    private boolean coerceInListOperandType(SqlValidatorScope scope, SqlNodeList nodeList, int index, DataType targetType) {
        SqlValidator sqlValidator = scope.getSqlValidator();
        SqlNode operand = nodeList.get(index);
        if (operand instanceof SqlDynamicParam) {
            return false;
        }
        DataType fromType = scope.getSqlValidator().inferDataType(operand, scope);
        if (fromType.getTypeName() == targetType.getTypeName()) {
            return false;
        }
        if (operand.getKind() == SqlKind.FUNC_CAST) {
            SqlNode expression = operand.cast(SqlCall.class).getOperand(0);
            DataType expressionType = sqlValidator.inferDataType(expression, scope);
            if (expressionType.getTypeName() == targetType.getTypeName()) {
                nodeList.set(index, expression);
                return true;
            }
            operand = expression;
        }
        DataTypeFactory dataTypeFactory = sqlValidator.getTypeFactory();
        SqlLiteral typeName = new SqlLiteral(operand.getPosition(), targetType.id(), dataTypeFactory.buildString());
        SqlBasicCall cast = new SqlBasicCall(operand.getPosition(), SqlKind.FUNC_CAST, SqlOperators.of(SqlKind.FUNC_CAST), operand, typeName);
        nodeList.set(index, cast);
        scope.getSqlValidator().setValidateNodeType(cast, targetType);
        return true;
    }

    public void likeCoercion(SqlValidatorScope scope, SqlBasicCall call) {
        if (call.getKind().isBelong(SqlKind.LIKE_KINDS)) {
            List<SqlNode> operandList;
            SqlNode leftNode;
            SqlValidator sqlValidator = scope.getSqlValidator();
            DataType leftDataType = sqlValidator.inferDataType(leftNode = (operandList = call.getOperandList()).get(0), scope);
            if (leftDataType.getCategory() != SqlTypeCategory.STRING) {
                throw Exceptions.of((ErrorCode)ErrorCode.LikeOperatorRequireStringType, (SqlParserPosition)call.getPosition(), (Object[])new Object[]{leftDataType.id()});
            }
            SqlNode rightNode = operandList.get(1);
            DataType dataType = sqlValidator.inferDataType(rightNode, scope);
            if (dataType != null) {
                this.coerceOperandType(scope, call, 1, leftDataType);
            }
        }
    }

    public void stringFuncCoercion(SqlValidatorScope scope, SqlBasicCall call) {
        if (call.getKind().isBelong(SqlKind.STRING_FUNC_KINDS)) {
            List<SqlNode> operandList = call.getOperandList();
            SqlValidator sqlValidator = scope.getSqlValidator();
            if (call.getKind() == SqlKind.FUNC_SUBSTR) {
                SqlNode sqlNode = operandList.get(0);
                DataType dataType = sqlValidator.inferDataType(sqlNode, scope);
                if (dataType != null) {
                    this.coerceOperandType(scope, call, 0, sqlValidator.getTypeFactory().buildString());
                }
            } else {
                for (int i = 0; i < operandList.size(); ++i) {
                    SqlNode sqlNode = operandList.get(i);
                    DataType dataType = sqlValidator.inferDataType(sqlNode, scope);
                    if (dataType == null) continue;
                    this.coerceOperandType(scope, call, i, sqlValidator.getTypeFactory().buildString());
                }
            }
        }
    }
}

