/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.unparse;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class SpaceString
implements CharSequence {
    private static final List<String> SPACE_LIST = new SpaceList();
    private final int length;

    public SpaceString(int length) {
        this.length = length;
    }

    @Override
    public String toString() {
        return SpaceString.of(this.length);
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public char charAt(int index) {
        return ' ';
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new SpaceString(end - start);
    }

    public static String of(int n) {
        return SPACE_LIST.get(n);
    }

    private static class SpaceList
    extends CopyOnWriteArrayList<String> {
        private SpaceList() {
        }

        @Override
        public String get(int index) {
            while (true) {
                try {
                    return (String)super.get(index);
                }
                catch (IndexOutOfBoundsException e) {
                    if (index < 0) {
                        throw e;
                    }
                    this.populate(Math.max(16, index + 1));
                    continue;
                }
                break;
            }
        }

        private synchronized void populate(int newSize) {
            int size = this.size();
            if (newSize <= size) {
                return;
            }
            final char[] chars = new char[newSize];
            Arrays.fill(chars, ' ');
            final int length = newSize - size;
            final int offset = size;
            this.addAll(new AbstractList<String>(){

                @Override
                public String get(int index) {
                    return new String(chars, 0, offset + index);
                }

                @Override
                public int size() {
                    return length;
                }
            });
        }
    }
}

