/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.unparse;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import kd.bos.flydb.core.sql.operator.FunctionDefinition;
import kd.bos.flydb.core.sql.operator.SqlOperator;
import kd.bos.flydb.core.sql.operator.SqlOperators;
import kd.bos.flydb.core.sql.operator.SqlUnaryOperator;
import kd.bos.flydb.core.sql.tree.SqlCall;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.tree.SqlLiteral;
import kd.bos.flydb.core.sql.tree.SqlNode;
import kd.bos.flydb.core.sql.type.DataType;
import kd.bos.flydb.core.sql.type.DataTypeFactory;
import kd.bos.flydb.core.sql.unparse.Casing;
import kd.bos.flydb.core.sql.unparse.NullCollation;
import kd.bos.flydb.core.sql.unparse.Quoting;
import kd.bos.flydb.core.sql.unparse.SqlPrettyWriter;
import kd.bos.flydb.core.sql.unparse.SqlWriter;

public class SqlDialect {
    public static final Context EMPTY_CONTEXT = SqlDialect.emptyContext();
    protected static final Set<SqlOperator> BUILT_IN_OPERATORS_LIST = ImmutableSet.builder().addAll(SqlOperators.getOperatorMap().values()).addAll(FunctionDefinition.getMap().values()).add((Object)SqlUnaryOperator.operator).build();
    protected final String identifierQuoteString;
    protected final String identifierEndQuoteString;
    protected final String identifierEscapedQuote;
    protected final String literalQuoteString;
    protected final String literalEndQuoteString;
    protected final String literalEscapedQuote;
    protected final NullCollation nullCollation;
    private final DataType dataTypeSystem;
    private final Casing unquotedCasing;
    private final Casing quotedCasing;
    private final boolean caseSensitive;
    private static final char[] HEXITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public SqlDialect(Context context) {
        this.nullCollation = Objects.requireNonNull(context.nullCollation());
        this.dataTypeSystem = Objects.requireNonNull(context.dataTypeSystem());
        this.literalQuoteString = Objects.requireNonNull(context.literalQuoteString());
        this.literalEndQuoteString = Objects.requireNonNull(context.literalQuoteString());
        this.literalEscapedQuote = Objects.requireNonNull(context.literalEscapedQuoteString());
        String identifierQuoteString = context.identifierQuoteString();
        if (identifierQuoteString != null && (identifierQuoteString = identifierQuoteString.trim()).equals("")) {
            identifierQuoteString = null;
        }
        this.identifierQuoteString = identifierQuoteString;
        String string = identifierQuoteString == null ? null : (this.identifierEndQuoteString = identifierQuoteString.equals("[") ? "]" : identifierQuoteString);
        this.identifierEscapedQuote = context.identifierEscapedQuoteString() == null ? (identifierQuoteString == null ? null : this.identifierEndQuoteString + this.identifierEndQuoteString) : context.identifierEscapedQuoteString();
        this.unquotedCasing = Objects.requireNonNull(context.unquotedCasing());
        this.quotedCasing = Objects.requireNonNull(context.quotedCasing());
        this.caseSensitive = context.caseSensitive();
    }

    private static Context emptyContext() {
        return new ContextImpl(null, null, -1, -1, "'", "''", null, null, Casing.UNCHANGED, Casing.TO_UPPER, true, NullCollation.HIGH, DataTypeFactory.instance.buildUnknownType());
    }

    public StringBuilder quoteIdentifier(StringBuilder buf, String val) {
        if (this.identifierQuoteString == null || this.identifierEndQuoteString == null || this.identifierEscapedQuote == null || !this.identifierNeedsQuote(val)) {
            buf.append(val);
        } else {
            buf.append(this.identifierQuoteString);
            buf.append(val.replace(this.identifierEndQuoteString, this.identifierEscapedQuote));
            buf.append(this.identifierEndQuoteString);
        }
        return buf;
    }

    protected boolean identifierNeedsQuote(String val) {
        return true;
    }

    public final String quoteStringLiteral(String val) {
        StringBuilder buf = new StringBuilder();
        this.quoteStringLiteral(buf, null, val);
        return buf.toString();
    }

    public void quoteStringLiteral(StringBuilder buf, String charsetName, String val) {
        if (SqlDialect.containsNonAscii(val) && charsetName == null) {
            this.quoteStringLiteralUnicode(buf, val);
        } else {
            if (charsetName != null) {
                buf.append("_");
                buf.append(charsetName);
            }
            buf.append(this.literalQuoteString);
            buf.append(val.replace(this.literalEndQuoteString, this.literalEscapedQuote));
            buf.append(this.literalEndQuoteString);
        }
    }

    public void unParseCall(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlOperator operator = call.getOperator();
        operator.unParse(writer, call, leftPrec, rightPrec);
    }

    public void unParseDateTimeLiteral(SqlWriter writer, SqlLiteral literal, int leftPrec, int rightPrec) {
        writer.literal(literal.toString());
    }

    protected static boolean containsNonAscii(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if ((c >= ' ' || c == '\n' || c == '\r') && c < '\u0080') continue;
            return true;
        }
        return false;
    }

    public void quoteStringLiteralUnicode(StringBuilder buf, String val) {
        buf.append("u&'");
        for (int i = 0; i < val.length(); ++i) {
            char c = val.charAt(i);
            if (c < ' ' || c >= '\u0080') {
                buf.append('\\');
                buf.append(HEXITS[c >> 12 & 0xF]);
                buf.append(HEXITS[c >> 8 & 0xF]);
                buf.append(HEXITS[c >> 4 & 0xF]);
                buf.append(HEXITS[c & 0xF]);
                continue;
            }
            if (c == '\'' || c == '\\') {
                buf.append(c);
                buf.append(c);
                continue;
            }
            buf.append(c);
        }
        buf.append("'");
    }

    public String unquoteStringLiteral(String val) {
        if (val != null && val.startsWith(this.literalQuoteString) && val.endsWith(this.literalEndQuoteString)) {
            String stripped = val.substring(this.literalQuoteString.length(), val.length() - this.literalEndQuoteString.length());
            return stripped.replace(this.literalEscapedQuote, this.literalEndQuoteString);
        }
        return val;
    }

    public boolean supportsAggregateFunction(SqlKind kind) {
        switch (kind) {
            case FUNC_COUNT: 
            case FUNC_SUM: 
            case FUNC_MIN: 
            case FUNC_MAX: {
                return true;
            }
        }
        return false;
    }

    public void unParseOffsetFetch(SqlWriter writer, SqlNode offset, SqlNode fetch) {
        SqlDialect.unParseFetchUsingAnsi(writer, offset, fetch);
    }

    public void unParseTopN(SqlWriter writer, SqlNode offset, SqlNode fetch) {
    }

    protected static void unParseFetchUsingAnsi(SqlWriter writer, SqlNode offset, SqlNode fetch) {
        Preconditions.checkArgument((fetch != null || offset != null ? 1 : 0) != 0);
        if (fetch != null) {
            if (offset != null) {
                writer.newlineAndIndent();
                SqlWriter.Frame fetchFrame = writer.startList(SqlWriter.FrameTypeEnum.LIMIT);
                writer.keyword("LIMIT");
                SqlWriter.Frame offsetFrame = writer.startList(SqlWriter.FrameTypeEnum.OFFSET);
                offset.unParse(writer, -1, -1);
                writer.endList(offsetFrame);
                writer.keyword(SqlPrettyWriter.COMMA.name());
                fetch.unParse(writer, -1, -1);
                writer.endList(fetchFrame);
            } else {
                writer.newlineAndIndent();
                SqlWriter.Frame fetchFrame = writer.startList(SqlWriter.FrameTypeEnum.LIMIT);
                writer.keyword("LIMIT");
                fetch.unParse(writer, -1, -1);
                writer.endList(fetchFrame);
            }
        }
    }

    protected Quoting getQuoting() {
        if ("\"".equals(this.identifierQuoteString) && "\"".equals(this.identifierEndQuoteString)) {
            return Quoting.DOUBLE_QUOTE;
        }
        if ("`".equals(this.identifierQuoteString) && "`".equals(this.identifierEndQuoteString)) {
            return Quoting.BACK_TICK;
        }
        if ("[".equals(this.identifierQuoteString) && "]".equals(this.identifierEndQuoteString)) {
            return Quoting.BRACKET;
        }
        return null;
    }

    public Casing getUnquotedCasing() {
        return this.unquotedCasing;
    }

    public Casing getQuotedCasing() {
        return this.quotedCasing;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    private static class ContextImpl
    implements Context {
        private final String databaseProductName;
        private final String databaseVersion;
        private final int databaseMajorVersion;
        private final int databaseMinorVersion;
        private final String literalQuoteString;
        private final String literalEscapedQuoteString;
        private final String identifierQuoteString;
        private final String identifierEscapedQuoteString;
        private final Casing unquotedCasing;
        private final Casing quotedCasing;
        private final boolean caseSensitive;
        private final NullCollation nullCollation;
        private final DataType dataTypeSystem;

        private ContextImpl(String databaseProductName, String databaseVersion, int databaseMajorVersion, int databaseMinorVersion, String literalQuoteString, String literalEscapedQuoteString, String identifierQuoteString, String identifierEscapedQuoteString, Casing quotedCasing, Casing unquotedCasing, boolean caseSensitive, NullCollation nullCollation, DataType dataTypeSystem) {
            this.databaseProductName = databaseProductName;
            this.databaseVersion = databaseVersion;
            this.databaseMajorVersion = databaseMajorVersion;
            this.databaseMinorVersion = databaseMinorVersion;
            this.literalQuoteString = literalQuoteString;
            this.literalEscapedQuoteString = literalEscapedQuoteString;
            this.identifierQuoteString = identifierQuoteString;
            this.identifierEscapedQuoteString = identifierEscapedQuoteString;
            this.quotedCasing = Objects.requireNonNull(quotedCasing, "quotedCasing");
            this.unquotedCasing = Objects.requireNonNull(unquotedCasing, "unquotedCasing");
            this.caseSensitive = caseSensitive;
            this.nullCollation = Objects.requireNonNull(nullCollation, "nullCollation");
            this.dataTypeSystem = Objects.requireNonNull(dataTypeSystem, "dataTypeSystem");
        }

        @Override
        public String databaseProductName() {
            return this.databaseProductName;
        }

        @Override
        public Context withDatabaseProductName(String databaseProductName) {
            return new ContextImpl(databaseProductName, this.databaseVersion, this.databaseMajorVersion, this.databaseMinorVersion, this.literalQuoteString, this.literalEscapedQuoteString, this.identifierQuoteString, this.identifierEscapedQuoteString, this.quotedCasing, this.unquotedCasing, this.caseSensitive, this.nullCollation, this.dataTypeSystem);
        }

        @Override
        public String databaseVersion() {
            return this.databaseVersion;
        }

        @Override
        public Context withDatabaseVersion(String databaseVersion) {
            return new ContextImpl(this.databaseProductName, databaseVersion, this.databaseMajorVersion, this.databaseMinorVersion, this.literalQuoteString, this.literalEscapedQuoteString, this.identifierQuoteString, this.identifierEscapedQuoteString, this.quotedCasing, this.unquotedCasing, this.caseSensitive, this.nullCollation, this.dataTypeSystem);
        }

        @Override
        public int databaseMajorVersion() {
            return this.databaseMajorVersion;
        }

        @Override
        public Context withDatabaseMajorVersion(int databaseMajorVersion) {
            return new ContextImpl(this.databaseProductName, this.databaseVersion, databaseMajorVersion, this.databaseMinorVersion, this.literalQuoteString, this.literalEscapedQuoteString, this.identifierQuoteString, this.identifierEscapedQuoteString, this.quotedCasing, this.unquotedCasing, this.caseSensitive, this.nullCollation, this.dataTypeSystem);
        }

        @Override
        public int databaseMinorVersion() {
            return this.databaseMinorVersion;
        }

        @Override
        public Context withDatabaseMinorVersion(int databaseMinorVersion) {
            return new ContextImpl(this.databaseProductName, this.databaseVersion, this.databaseMajorVersion, databaseMinorVersion, this.literalQuoteString, this.literalEscapedQuoteString, this.identifierQuoteString, this.identifierEscapedQuoteString, this.quotedCasing, this.unquotedCasing, this.caseSensitive, this.nullCollation, this.dataTypeSystem);
        }

        @Override
        public String literalQuoteString() {
            return this.literalQuoteString;
        }

        @Override
        public Context withLiteralQuoteString(String literalQuoteString) {
            return new ContextImpl(this.databaseProductName, this.databaseVersion, this.databaseMajorVersion, this.databaseMinorVersion, literalQuoteString, this.literalEscapedQuoteString, this.identifierQuoteString, this.identifierEscapedQuoteString, this.quotedCasing, this.unquotedCasing, this.caseSensitive, this.nullCollation, this.dataTypeSystem);
        }

        @Override
        public String literalEscapedQuoteString() {
            return this.literalEscapedQuoteString;
        }

        @Override
        public Context withLiteralEscapedQuoteString(String literalEscapedQuoteString) {
            return new ContextImpl(this.databaseProductName, this.databaseVersion, this.databaseMajorVersion, this.databaseMinorVersion, this.literalQuoteString, literalEscapedQuoteString, this.identifierQuoteString, this.identifierEscapedQuoteString, this.quotedCasing, this.unquotedCasing, this.caseSensitive, this.nullCollation, this.dataTypeSystem);
        }

        @Override
        public String identifierQuoteString() {
            return this.identifierQuoteString;
        }

        @Override
        public Context withIdentifierQuoteString(String identifierQuoteString) {
            return new ContextImpl(this.databaseProductName, this.databaseVersion, this.databaseMajorVersion, this.databaseMinorVersion, this.literalQuoteString, this.literalEscapedQuoteString, identifierQuoteString, this.identifierEscapedQuoteString, this.quotedCasing, this.unquotedCasing, this.caseSensitive, this.nullCollation, this.dataTypeSystem);
        }

        @Override
        public String identifierEscapedQuoteString() {
            return this.identifierEscapedQuoteString;
        }

        @Override
        public Context withIdentifierEscapedQuoteString(String identifierEscapedQuoteString) {
            return new ContextImpl(this.databaseProductName, this.databaseVersion, this.databaseMajorVersion, this.databaseMinorVersion, this.literalQuoteString, this.literalEscapedQuoteString, this.identifierQuoteString, identifierEscapedQuoteString, this.quotedCasing, this.unquotedCasing, this.caseSensitive, this.nullCollation, this.dataTypeSystem);
        }

        @Override
        public Casing unquotedCasing() {
            return this.unquotedCasing;
        }

        @Override
        public Context withUnquotedCasing(Casing unquotedCasing) {
            return new ContextImpl(this.databaseProductName, this.databaseVersion, this.databaseMajorVersion, this.databaseMinorVersion, this.literalQuoteString, this.literalEscapedQuoteString, this.identifierQuoteString, this.identifierEscapedQuoteString, this.quotedCasing, unquotedCasing, this.caseSensitive, this.nullCollation, this.dataTypeSystem);
        }

        @Override
        public Casing quotedCasing() {
            return this.quotedCasing;
        }

        @Override
        public Context withQuotedCasing(Casing quotedCasing) {
            return new ContextImpl(this.databaseProductName, this.databaseVersion, this.databaseMajorVersion, this.databaseMinorVersion, this.literalQuoteString, this.literalEscapedQuoteString, this.identifierQuoteString, this.identifierEscapedQuoteString, quotedCasing, this.unquotedCasing, this.caseSensitive, this.nullCollation, this.dataTypeSystem);
        }

        @Override
        public boolean caseSensitive() {
            return this.caseSensitive;
        }

        @Override
        public Context withCaseSensitive(boolean caseSensitive) {
            return new ContextImpl(this.databaseProductName, this.databaseVersion, this.databaseMajorVersion, this.databaseMinorVersion, this.literalQuoteString, this.literalEscapedQuoteString, this.identifierQuoteString, this.identifierEscapedQuoteString, this.quotedCasing, this.unquotedCasing, caseSensitive, this.nullCollation, this.dataTypeSystem);
        }

        @Override
        public NullCollation nullCollation() {
            return this.nullCollation;
        }

        @Override
        public Context withNullCollation(NullCollation nullCollation) {
            return new ContextImpl(this.databaseProductName, this.databaseVersion, this.databaseMajorVersion, this.databaseMinorVersion, this.literalQuoteString, this.literalEscapedQuoteString, this.identifierQuoteString, this.identifierEscapedQuoteString, this.quotedCasing, this.unquotedCasing, this.caseSensitive, nullCollation, this.dataTypeSystem);
        }

        @Override
        public DataType dataTypeSystem() {
            return this.dataTypeSystem;
        }

        @Override
        public Context withDataTypeSystem(DataType dataTypeSystem) {
            return new ContextImpl(this.databaseProductName, this.databaseVersion, this.databaseMajorVersion, this.databaseMinorVersion, this.literalQuoteString, this.literalEscapedQuoteString, this.identifierQuoteString, this.identifierEscapedQuoteString, this.quotedCasing, this.unquotedCasing, this.caseSensitive, this.nullCollation, dataTypeSystem);
        }
    }

    public static interface Context {
        public String databaseProductName();

        public Context withDatabaseProductName(String var1);

        public String databaseVersion();

        public Context withDatabaseVersion(String var1);

        public int databaseMajorVersion();

        public Context withDatabaseMajorVersion(int var1);

        public int databaseMinorVersion();

        public Context withDatabaseMinorVersion(int var1);

        public String literalQuoteString();

        public Context withLiteralQuoteString(String var1);

        public String literalEscapedQuoteString();

        public Context withLiteralEscapedQuoteString(String var1);

        public String identifierQuoteString();

        public Context withIdentifierQuoteString(String var1);

        public String identifierEscapedQuoteString();

        public Context withIdentifierEscapedQuoteString(String var1);

        public Casing unquotedCasing();

        public Context withUnquotedCasing(Casing var1);

        public Casing quotedCasing();

        public Context withQuotedCasing(Casing var1);

        public boolean caseSensitive();

        public Context withCaseSensitive(boolean var1);

        public NullCollation nullCollation();

        public Context withNullCollation(NullCollation var1);

        public DataType dataTypeSystem();

        public Context withDataTypeSystem(DataType var1);
    }
}

