/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.unparse;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Consumer;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.sql.dialect.KSQLDialect;
import kd.bos.flydb.core.sql.operator.SqlOperator;
import kd.bos.flydb.core.sql.tree.SqlNode;
import kd.bos.flydb.core.sql.tree.SqlNodeList;
import kd.bos.flydb.core.sql.unparse.SpaceString;
import kd.bos.flydb.core.sql.unparse.SqlDialect;
import kd.bos.flydb.core.sql.unparse.SqlString;
import kd.bos.flydb.core.sql.unparse.SqlWriter;
import kd.bos.flydb.core.sql.unparse.SqlWriterConfig;

public class SqlPrettyWriter
implements SqlWriter {
    private static final SqlWriterConfig CONFIG = SqlWriterConfig.of().withDialect(KSQLDialect.DEFAULT);
    private static final CharSequence MAX = new SpaceString(Integer.MAX_VALUE);
    private static final Bean DEFAULT_BEAN = new SqlPrettyWriter(SqlPrettyWriter.config().withDialect(KSQLDialect.DEFAULT)).getBean();
    public static final String NL = System.getProperty("line.separator");
    private final SqlDialect dialect;
    private final StringBuilder buf;
    private final Deque<FrameImpl> listStack = new ArrayDeque<FrameImpl>();
    private ImmutableList.Builder<Integer> dynamicParameters;
    protected FrameImpl frame;
    private boolean needWhitespace;
    protected String nextWhitespace;
    private SqlWriterConfig config;
    private Bean bean;
    private int currentIndent;
    private int lineStart;

    public SqlPrettyWriter(SqlWriterConfig config, StringBuilder buf) {
        this.buf = Objects.requireNonNull(buf, "buf");
        this.dialect = Objects.requireNonNull(config.dialect());
        this.config = Objects.requireNonNull(config, "config");
        this.lineStart = 0;
        this.reset();
    }

    public SqlPrettyWriter(SqlWriterConfig config) {
        this(config, new StringBuilder());
    }

    public SqlPrettyWriter() {
        this(SqlPrettyWriter.config());
    }

    public static SqlWriterConfig config() {
        return CONFIG;
    }

    @Deprecated
    public void setSubQueryStyle(SqlWriter.SubQueryStyle subQueryStyle) {
        this.config = this.config.withSubQueryStyle(subQueryStyle);
    }

    @Override
    @Deprecated
    public int getIndentation() {
        return this.config.indentation();
    }

    @Override
    @Deprecated
    public boolean isAlwaysUseParentheses() {
        return this.config.alwaysUseParentheses();
    }

    @Override
    public boolean inQuery() {
        return this.frame == null || this.frame.frameType == SqlWriter.FrameTypeEnum.ORDER_BY || this.frame.frameType == SqlWriter.FrameTypeEnum.SETOP;
    }

    @Override
    @Deprecated
    public boolean isQuoteAllIdentifiers() {
        return this.config.quoteAllIdentifiers();
    }

    @Override
    @Deprecated
    public boolean isClauseStartsLine() {
        return this.config.clauseStartsLine();
    }

    @Override
    @Deprecated
    public boolean isSelectListItemsOnSeparateLines() {
        return this.config.selectListItemsOnSeparateLines();
    }

    @Deprecated
    public boolean isWhereListItemsOnSeparateLines() {
        return this.config.whereListItemsOnSeparateLines();
    }

    @Deprecated
    public boolean isSelectListExtraIndentFlag() {
        return this.config.selectListExtraIndentFlag();
    }

    @Override
    @Deprecated
    public boolean isKeywordsLowerCase() {
        return this.config.keywordsLowerCase();
    }

    @Deprecated
    public int getLineLength() {
        return this.config.lineLength();
    }

    @Override
    public void resetSettings() {
        this.reset();
        this.config = SqlPrettyWriter.config();
    }

    @Override
    public final void reset() {
        this.buf.setLength(0);
        this.lineStart = 0;
        this.dynamicParameters = null;
        this.setNeedWhitespace(false);
        this.nextWhitespace = " ";
    }

    private Bean getBean() {
        if (this.bean == null) {
            this.bean = new Bean(this);
        }
        return this.bean;
    }

    public void describe(PrintWriter pw, boolean omitDefaults) {
        Bean properties = this.getBean();
        String[] propertyNames = properties.getPropertyNames();
        int count = 0;
        for (String key : propertyNames) {
            Object defaultValue;
            Object value = properties.get(key);
            if (Objects.equals(value, defaultValue = DEFAULT_BEAN.get(key))) continue;
            if (count++ > 0) {
                pw.print(",");
            }
            pw.print(key + "=" + value);
        }
    }

    public void setSettings(Properties properties) {
        String[] propertyNames;
        this.resetSettings();
        Bean bean = this.getBean();
        for (String propertyName : propertyNames = bean.getPropertyNames()) {
            String value = properties.getProperty(propertyName);
            if (value == null) continue;
            bean.set(propertyName, value);
        }
    }

    @Deprecated
    public void setSelectListExtraIndentFlag(boolean selectListExtraIndentFlag) {
        this.config = this.config.withSelectListExtraIndentFlag(selectListExtraIndentFlag);
    }

    @Override
    public void newlineAndIndent() {
        this.newlineAndIndent(this.currentIndent);
    }

    public void newlineAndIndent(int indent) {
        this.buf.append(NL);
        this.lineStart = this.buf.length();
        this.indent(indent);
        this.setNeedWhitespace(false);
    }

    void indent(int indent) {
        if (indent < 0) {
            throw new IllegalArgumentException("negative indent " + indent);
        }
        this.buf.append(MAX, 0, indent);
    }

    protected FrameImpl createListFrame(SqlWriter.FrameType frameType, String keyword, String open, String close) {
        int chopColumn;
        SqlWriter.FrameTypeEnum frameTypeEnum = frameType instanceof SqlWriter.FrameTypeEnum ? (SqlWriter.FrameTypeEnum)frameType : SqlWriter.FrameTypeEnum.OTHER;
        int indentation = this.config.indentation();
        boolean newlineAfterOpen = false;
        boolean newlineBeforeSep = false;
        boolean newlineAfterSep = false;
        boolean newlineBeforeClose = false;
        int left = this.column();
        int sepIndent = indentation;
        int extraIndent = 0;
        SqlWriterConfig.LineFolding fold = this.fold(frameTypeEnum);
        boolean newline = fold == SqlWriterConfig.LineFolding.TALL;
        switch (frameTypeEnum) {
            case SELECT: 
            case SHOW: {
                extraIndent = indentation;
                newlineAfterOpen = false;
                newlineBeforeSep = this.config.clauseStartsLine();
                newlineAfterSep = false;
                sepIndent = 0;
                break;
            }
            case SETOP: {
                extraIndent = 0;
                newlineAfterOpen = false;
                newlineBeforeSep = this.config.clauseStartsLine();
                newlineAfterSep = this.config.clauseStartsLine();
                sepIndent = 0;
                break;
            }
            case SELECT_LIST: 
            case FROM_LIST: 
            case JOIN: 
            case GROUP_BY_LIST: 
            case ORDER_BY_LIST: 
            case WINDOW_DECL_LIST: 
            case VALUES: {
                if (this.config.selectListExtraIndentFlag()) {
                    extraIndent = indentation;
                }
                left = this.frame == null ? 0 : this.frame.left;
                newlineAfterOpen = this.config.clauseEndsLine() && (fold == SqlWriterConfig.LineFolding.TALL || fold == SqlWriterConfig.LineFolding.STEP);
                newlineBeforeSep = false;
                newlineAfterSep = newline;
                if (!this.config.leadingComma() || !newline) break;
                newlineBeforeSep = true;
                newlineAfterSep = false;
                sepIndent = -", ".length();
                break;
            }
            case WHERE_LIST: {
                extraIndent = indentation;
                newlineAfterOpen = newline && this.config.clauseEndsLine();
                newlineBeforeSep = newline;
                sepIndent = 0;
                newlineAfterSep = false;
                break;
            }
            case ORDER_BY: {
                extraIndent = indentation;
                newlineAfterOpen = newline;
                newlineBeforeSep = false;
                sepIndent = 0;
                newlineAfterSep = newline;
                break;
            }
            case CASE: {
                newlineAfterOpen = newline;
                newlineBeforeSep = newline;
                newlineBeforeClose = newline;
                sepIndent = 0;
                break;
            }
        }
        SqlWriterConfig.LineFolding lineFolding = this.config.lineFolding();
        if (lineFolding == null) {
            lineFolding = SqlWriterConfig.LineFolding.WIDE;
            chopColumn = -1;
        } else {
            chopColumn = this.config.foldLength() > 0 && (lineFolding == SqlWriterConfig.LineFolding.CHOP || lineFolding == SqlWriterConfig.LineFolding.FOLD || lineFolding == SqlWriterConfig.LineFolding.STEP) ? left + this.config.foldLength() : -1;
        }
        switch (frameTypeEnum) {
            case SELECT: 
            case SHOW: 
            case SETOP: 
            case SELECT_LIST: 
            case GROUP_BY_LIST: 
            case ORDER_BY_LIST: 
            case WINDOW_DECL_LIST: 
            case VALUES: 
            case WHERE_LIST: 
            case ORDER_BY: {
                return new FrameImpl(frameType, keyword, open, close, left, extraIndent, chopColumn, lineFolding, newlineAfterOpen, newlineBeforeSep, sepIndent, newlineAfterSep, false, false);
            }
            case SUB_QUERY: {
                switch (this.config.subQueryStyle()) {
                    case BLACK: {
                        open = this.padRight("(", indentation - 1);
                        return new FrameImpl(frameType, keyword, open, close, left, 0, chopColumn, lineFolding, false, true, indentation, false, false, false){

                            protected void _before() {
                                SqlPrettyWriter.this.newlineAndIndent();
                            }
                        };
                    }
                    case HYDE: {
                        return new FrameImpl(frameType, keyword, open, close, left, 0, chopColumn, lineFolding, false, true, 0, false, false, false){

                            protected void _before() {
                                SqlPrettyWriter.this.nextWhitespace = NL;
                            }
                        };
                    }
                }
                throw Exceptions.unParse.unexpected((Enum)this.config.subQueryStyle());
            }
            case FUN_CALL: {
                this.setNeedWhitespace(false);
                return new FrameImpl(frameType, keyword, open, close, left, indentation, chopColumn, lineFolding, false, false, indentation, false, false, false);
            }
            case PARENTHESES: {
                open = "(";
                close = ")";
            }
            case IDENTIFIER: 
            case SIMPLE: {
                return new FrameImpl(frameType, keyword, open, close, left, indentation, chopColumn, lineFolding, false, false, indentation, false, false, false);
            }
            case FROM_LIST: 
            case JOIN: {
                newlineBeforeSep = newline;
                sepIndent = 0;
                newlineAfterSep = false;
                final boolean newlineBeforeComma = this.config.leadingComma() && newline;
                final boolean newlineAfterComma = !this.config.leadingComma() && newline;
                return new FrameImpl(frameType, keyword, open, close, left, indentation, chopColumn, lineFolding, newlineAfterOpen, newlineBeforeSep, sepIndent, newlineAfterSep, false, false){

                    @Override
                    protected void sep(boolean printFirst, String sep) {
                        boolean newlineAfterSep;
                        boolean newlineBeforeSep;
                        if (sep.equals(",")) {
                            newlineBeforeSep = newlineBeforeComma;
                            newlineAfterSep = newlineAfterComma;
                        } else {
                            newlineBeforeSep = this.newlineBeforeSep;
                            newlineAfterSep = this.newlineAfterSep;
                        }
                        if (this.itemCount == 0) {
                            if (this.newlineAfterOpen) {
                                SqlPrettyWriter.this.newlineAndIndent(SqlPrettyWriter.this.currentIndent);
                            }
                        } else if (newlineBeforeSep) {
                            SqlPrettyWriter.this.newlineAndIndent(SqlPrettyWriter.this.currentIndent + this.sepIndent);
                        }
                        if (this.itemCount > 0 || printFirst) {
                            SqlPrettyWriter.this.keyword(sep);
                            SqlPrettyWriter.this.nextWhitespace = newlineAfterSep ? NL : " ";
                        }
                        ++this.itemCount;
                    }
                };
            }
        }
        return new FrameImpl(frameType, keyword, open, close, left, indentation, chopColumn, lineFolding, newlineAfterOpen, newlineBeforeSep, sepIndent, newlineAfterSep, newlineBeforeClose, false);
    }

    private String padRight(String str, int n) {
        int x = n - str.length();
        if (x <= 0) {
            return str;
        }
        return new StringBuilder(str).append(MAX, 0, x).toString();
    }

    private SqlWriterConfig.LineFolding fold(SqlWriter.FrameTypeEnum frameType) {
        switch (frameType) {
            case SELECT_LIST: {
                return SqlPrettyWriter.f3(this.config.selectFolding(), this.config.lineFolding(), this.config.selectListItemsOnSeparateLines());
            }
            case GROUP_BY_LIST: {
                return SqlPrettyWriter.f3(this.config.groupByFolding(), this.config.lineFolding(), this.config.selectListItemsOnSeparateLines());
            }
            case ORDER_BY_LIST: {
                return SqlPrettyWriter.f3(this.config.orderByFolding(), this.config.lineFolding(), this.config.selectListItemsOnSeparateLines());
            }
            case WHERE_LIST: {
                return SqlPrettyWriter.f3(this.config.whereFolding(), this.config.lineFolding(), this.config.whereListItemsOnSeparateLines());
            }
            case WINDOW_DECL_LIST: {
                return SqlPrettyWriter.f3(this.config.windowFolding(), this.config.lineFolding(), this.config.clauseStartsLine() && this.config.windowDeclListNewline());
            }
            case VALUES: {
                return SqlPrettyWriter.f3(this.config.valuesFolding(), this.config.lineFolding(), this.config.valuesListNewline());
            }
            case FROM_LIST: 
            case JOIN: {
                return SqlPrettyWriter.f3(this.config.fromFolding(), this.config.lineFolding(), this.config.caseClausesOnNewLines());
            }
            case CASE: {
                return SqlPrettyWriter.f3(null, null, this.config.caseClausesOnNewLines());
            }
        }
        return SqlWriterConfig.LineFolding.WIDE;
    }

    private static SqlWriterConfig.LineFolding f3(SqlWriterConfig.LineFolding folding0, SqlWriterConfig.LineFolding folding1, boolean opt) {
        return folding0 != null ? folding0 : (folding1 != null ? folding1 : (opt ? SqlWriterConfig.LineFolding.TALL : SqlWriterConfig.LineFolding.WIDE));
    }

    protected SqlWriter.Frame startList(SqlWriter.FrameType frameType, String keyword, String open, String close) {
        assert (frameType != null);
        FrameImpl frame = this.frame;
        if (frame != null) {
            if (frame.itemCount++ == 0 && frame.newlineAfterOpen) {
                this.newlineAndIndent();
            } else if (frameType == SqlWriter.FrameTypeEnum.SUB_QUERY && this.config.subQueryStyle() == SqlWriter.SubQueryStyle.BLACK) {
                this.newlineAndIndent(this.currentIndent - frame.extraIndent);
            }
            this.currentIndent += frame.extraIndent(frameType);
            assert (!this.listStack.contains(frame));
            this.listStack.push(frame);
        }
        this.frame = frame = this.createListFrame(frameType, keyword, open, close);
        frame.before();
        return frame;
    }

    @Override
    public void endList(SqlWriter.Frame frame) {
        FrameImpl endedFrame = (FrameImpl)frame;
        Preconditions.checkArgument((frame == this.frame ? 1 : 0) != 0, (Object)"Frame does not match current frame");
        if (endedFrame == null) {
            throw new RuntimeException("No list started");
        }
        if (endedFrame.open.equals("(") && !endedFrame.close.equals(")")) {
            throw new RuntimeException("Expected ')'");
        }
        if (endedFrame.newlineBeforeClose) {
            this.newlineAndIndent();
        }
        this.keyword(endedFrame.close);
        if (endedFrame.newlineAfterClose) {
            this.newlineAndIndent();
        }
        if (this.listStack.isEmpty()) {
            this.frame = null;
            assert (this.currentIndent == 0) : this.currentIndent;
        } else {
            this.frame = this.listStack.pop();
            this.currentIndent -= this.frame.extraIndent(endedFrame.frameType);
        }
    }

    public String format(SqlNode node) {
        assert (this.frame == null);
        node.unParse(this, 0, 0);
        assert (this.frame == null);
        return this.toString();
    }

    public String toString() {
        return this.buf.toString();
    }

    @Override
    public SqlString toSqlString() {
        ImmutableList dynamicParameters = this.dynamicParameters == null ? null : this.dynamicParameters.build();
        return new SqlString(this.dialect, this.toString(), (ImmutableList<Integer>)dynamicParameters);
    }

    @Override
    public SqlDialect getDialect() {
        return this.dialect;
    }

    @Override
    public void literal(String s) {
        this.print(s);
        this.setNeedWhitespace(true);
    }

    @Override
    public void keyword(String s) {
        this.maybeWhitespace(s);
        this.buf.append(this.isKeywordsLowerCase() ? s.toLowerCase(Locale.ROOT) : s.toUpperCase(Locale.ROOT));
        if (!s.equals("")) {
            this.setNeedWhitespace(SqlPrettyWriter.needWhitespaceAfter(s));
        }
    }

    private void maybeWhitespace(String s) {
        if (this.tooLong(s) || this.needWhitespace && SqlPrettyWriter.needWhitespaceBefore(s)) {
            this.whiteSpace();
        }
    }

    private static boolean needWhitespaceBefore(String s) {
        return !s.equals(",") && !s.equals(".") && !s.equals(")") && !s.equals("[") && !s.equals("]") && !s.equals("");
    }

    private static boolean needWhitespaceAfter(String s) {
        return !s.equals("(") && !s.equals("[") && !s.equals(".");
    }

    protected void whiteSpace() {
        if (this.needWhitespace) {
            if (NL.equals(this.nextWhitespace)) {
                this.newlineAndIndent();
            } else {
                this.buf.append(this.nextWhitespace);
            }
            this.nextWhitespace = " ";
            this.setNeedWhitespace(false);
        }
    }

    private int column() {
        return this.buf.length() - this.lineStart;
    }

    protected boolean tooLong(String s) {
        boolean result;
        int lineLength = this.config.lineLength();
        boolean bl = result = lineLength > 0 && this.column() > this.currentIndent && this.column() + s.length() >= lineLength;
        if (result) {
            this.nextWhitespace = NL;
        }
        return result;
    }

    @Override
    public void print(String s) {
        this.maybeWhitespace(s);
        this.buf.append(s);
    }

    @Override
    public void print(int x) {
        this.maybeWhitespace("0");
        this.buf.append(x);
    }

    @Override
    public void identifier(String name, boolean quoted) {
        this.maybeWhitespace(name);
        if (this.isQuoteAllIdentifiers() || quoted) {
            this.dialect.quoteIdentifier(this.buf, name);
        } else {
            this.buf.append(name);
        }
        this.setNeedWhitespace(true);
    }

    @Override
    public void dynamicParam(int index) {
        if (this.dynamicParameters == null) {
            this.dynamicParameters = ImmutableList.builder();
        }
        this.dynamicParameters.add((Object)index);
        this.print("?");
        this.setNeedWhitespace(true);
    }

    @Override
    public void fetchOffset(SqlNode fetch, SqlNode offset) {
        if (fetch == null && offset == null) {
            return;
        }
        this.dialect.unParseOffsetFetch(this, offset, fetch);
    }

    @Override
    public void topN(SqlNode fetch, SqlNode offset) {
        if (fetch == null && offset == null) {
            return;
        }
        this.dialect.unParseTopN(this, offset, fetch);
    }

    @Override
    public SqlWriter.Frame startFunCall(String funName) {
        this.keyword(funName);
        this.setNeedWhitespace(false);
        return this.startList(SqlWriter.FrameTypeEnum.FUN_CALL, "(", ")");
    }

    @Override
    public void endFunCall(SqlWriter.Frame frame) {
        this.endList(this.frame);
    }

    @Override
    public SqlWriter.Frame startList(String open, String close) {
        return this.startList(SqlWriter.FrameTypeEnum.SIMPLE, null, open, close);
    }

    @Override
    public SqlWriter.Frame startList(SqlWriter.FrameTypeEnum frameType) {
        assert (frameType != null);
        return this.startList(frameType, null, "", "");
    }

    @Override
    public SqlWriter.Frame startList(SqlWriter.FrameType frameType, String open, String close) {
        assert (frameType != null);
        return this.startList(frameType, null, open, close);
    }

    @Override
    public SqlWriter list(SqlWriter.FrameTypeEnum frameType, Consumer<SqlWriter> action) {
        SqlWriter.Frame selectListFrame = this.startList(SqlWriter.FrameTypeEnum.SELECT_LIST);
        SqlPrettyWriter w = this;
        action.accept(w);
        this.endList(selectListFrame);
        return this;
    }

    @Override
    public SqlWriter list(SqlWriter.FrameTypeEnum frameType, SqlOperator sepOp, SqlNodeList list) {
        SqlWriter.Frame frame = this.startList(frameType);
        ((FrameImpl)frame).list(list, sepOp);
        this.endList(frame);
        return this;
    }

    @Override
    public void sep(String sep) {
        this.sep(sep, !sep.equals(",") && !sep.equals("."));
    }

    @Override
    public void sep(String sep, boolean printFirst) {
        if (this.frame == null) {
            throw new RuntimeException("No list started");
        }
        if (sep.startsWith(" ") || sep.endsWith(" ")) {
            throw new RuntimeException("Separator must not contain whitespace");
        }
        this.frame.sep(printFirst, sep);
    }

    @Override
    public void setNeedWhitespace(boolean needWhitespace) {
        this.needWhitespace = needWhitespace;
    }

    private static class Bean {
        private final SqlPrettyWriter o;
        private final Map<String, Method> getterMethods = new HashMap<String, Method>();
        private final Map<String, Method> setterMethods = new HashMap<String, Method>();

        Bean(SqlPrettyWriter o) {
            this.o = o;
            for (Method method : o.getClass().getMethods()) {
                String attributeName;
                if (method.getName().startsWith("set") && method.getReturnType() == Void.class && method.getParameterTypes().length == 1) {
                    attributeName = Bean.stripPrefix(method.getName(), 3);
                    this.setterMethods.put(attributeName, method);
                }
                if (method.getName().startsWith("get") && method.getReturnType() != Void.class && method.getParameterTypes().length == 0) {
                    attributeName = Bean.stripPrefix(method.getName(), 3);
                    this.getterMethods.put(attributeName, method);
                }
                if (!method.getName().startsWith("is") || method.getReturnType() != Boolean.class || method.getParameterTypes().length != 0) continue;
                attributeName = Bean.stripPrefix(method.getName(), 2);
                this.getterMethods.put(attributeName, method);
            }
        }

        private static String stripPrefix(String name, int offset) {
            return name.substring(offset, offset + 1).toLowerCase(Locale.ROOT) + name.substring(offset + 1);
        }

        public void set(String name, String value) {
            Method method = Objects.requireNonNull(this.setterMethods.get(name), () -> "setter method " + name + " not found");
            try {
                method.invoke((Object)this.o, value);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw Exceptions.unParse.throwAsRuntime((Throwable)e);
            }
        }

        public Object get(String name) {
            Method method = Objects.requireNonNull(this.getterMethods.get(name), () -> "getter method " + name + " not found");
            try {
                return method.invoke((Object)this.o, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw Exceptions.unParse.throwAsRuntime((Throwable)e);
            }
        }

        public String[] getPropertyNames() {
            HashSet<String> names = new HashSet<String>();
            names.addAll(this.getterMethods.keySet());
            names.addAll(this.setterMethods.keySet());
            return names.toArray(new String[0]);
        }
    }

    protected class FrameImpl
    implements SqlWriter.Frame {
        final SqlWriter.FrameType frameType;
        final String keyword;
        final String open;
        final String close;
        private final int left;
        final int extraIndent;
        final int sepIndent;
        int itemCount;
        public final boolean newlineBeforeSep;
        public final boolean newlineAfterSep;
        protected final boolean newlineBeforeClose;
        protected final boolean newlineAfterClose;
        protected final boolean newlineAfterOpen;
        private final int chopLimit;
        private final SqlWriterConfig.LineFolding lineFolding;

        FrameImpl(SqlWriter.FrameType frameType, String keyword, String open, String close, int left, int extraIndent, int chopLimit, SqlWriterConfig.LineFolding lineFolding, boolean newlineAfterOpen, boolean newlineBeforeSep, int sepIndent, boolean newlineAfterSep, boolean newlineBeforeClose, boolean newlineAfterClose) {
            this.frameType = frameType;
            this.keyword = keyword;
            this.open = open;
            this.close = close;
            this.left = left;
            this.extraIndent = extraIndent;
            this.chopLimit = chopLimit;
            this.lineFolding = lineFolding;
            this.newlineAfterOpen = newlineAfterOpen;
            this.newlineBeforeSep = newlineBeforeSep;
            this.newlineAfterSep = newlineAfterSep;
            this.newlineBeforeClose = newlineBeforeClose;
            this.newlineAfterClose = newlineAfterClose;
            this.sepIndent = sepIndent;
            assert (chopLimit >= 0 == (lineFolding == SqlWriterConfig.LineFolding.CHOP || lineFolding == SqlWriterConfig.LineFolding.FOLD || lineFolding == SqlWriterConfig.LineFolding.STEP));
        }

        protected void before() {
            if (this.open != null && !this.open.equals("")) {
                SqlPrettyWriter.this.keyword(this.open);
            }
        }

        protected void after() {
        }

        protected void sep(boolean printFirst, String sep) {
            if (this.itemCount == 0) {
                if (this.newlineAfterOpen) {
                    SqlPrettyWriter.this.newlineAndIndent(SqlPrettyWriter.this.currentIndent);
                }
            } else if (this.newlineBeforeSep) {
                SqlPrettyWriter.this.newlineAndIndent(SqlPrettyWriter.this.currentIndent + this.sepIndent);
            }
            if (this.itemCount > 0 || printFirst) {
                SqlPrettyWriter.this.keyword(sep);
                SqlPrettyWriter.this.nextWhitespace = this.newlineAfterSep ? NL : " ";
            }
            ++this.itemCount;
        }

        int extraIndent(SqlWriter.FrameType subFrameType) {
            if (this.frameType == SqlWriter.FrameTypeEnum.ORDER_BY && subFrameType == SqlWriter.FrameTypeEnum.ORDER_BY_LIST) {
                return SqlPrettyWriter.this.config.indentation();
            }
            if (subFrameType.needsIndent()) {
                return this.extraIndent;
            }
            return 0;
        }

        void list(SqlNodeList list, SqlOperator sepOp) {
            switch (this.lineFolding) {
                case CHOP: 
                case FOLD: {
                    int sepIndent;
                    boolean newlineAfterSep;
                    boolean newlineBeforeSep;
                    boolean newline;
                    int chopLimit;
                    SqlWriterConfig.LineFolding lineFolding;
                    Save save = new Save();
                    if (this.list2(list, sepOp)) break;
                    save.restore();
                    boolean newlineAfterOpen = SqlPrettyWriter.this.config.clauseEndsLine();
                    if (this.lineFolding == SqlWriterConfig.LineFolding.CHOP) {
                        lineFolding = SqlWriterConfig.LineFolding.TALL;
                        chopLimit = -1;
                    } else {
                        lineFolding = SqlWriterConfig.LineFolding.FOLD;
                        chopLimit = this.chopLimit;
                    }
                    boolean bl = newline = lineFolding == SqlWriterConfig.LineFolding.TALL;
                    if (SqlPrettyWriter.this.config.leadingComma() && newline) {
                        newlineBeforeSep = true;
                        newlineAfterSep = false;
                        sepIndent = -", ".length();
                    } else if (newline) {
                        newlineBeforeSep = false;
                        newlineAfterSep = true;
                        sepIndent = this.sepIndent;
                    } else {
                        newlineBeforeSep = false;
                        newlineAfterSep = false;
                        sepIndent = this.sepIndent;
                    }
                    FrameImpl frame2 = new FrameImpl(this.frameType, this.keyword, this.open, this.close, this.left, this.extraIndent, chopLimit, lineFolding, newlineAfterOpen, newlineBeforeSep, sepIndent, newlineAfterSep, this.newlineBeforeClose, this.newlineAfterClose);
                    frame2.list2(list, sepOp);
                    break;
                }
                default: {
                    this.list2(list, sepOp);
                }
            }
        }

        private boolean list2(SqlNodeList list, SqlOperator sepOp) {
            int lprec = sepOp.getRightPrecedence();
            int rprec = sepOp.getLeftPrecedence();
            if (this.chopLimit < 0) {
                for (int i = 0; i < list.size(); ++i) {
                    SqlNode node = list.get(i);
                    this.sep(false, sepOp.name());
                    node.unParse(SqlPrettyWriter.this, lprec, rprec);
                }
            } else if (this.newlineBeforeSep) {
                for (int i = 0; i < list.size(); ++i) {
                    SqlNode node = list.get(i);
                    this.sep(false, sepOp.name());
                    Save prevSize = new Save();
                    node.unParse(SqlPrettyWriter.this, lprec, rprec);
                    if (SqlPrettyWriter.this.column() <= this.chopLimit) continue;
                    if (this.lineFolding == SqlWriterConfig.LineFolding.CHOP || this.lineFolding == SqlWriterConfig.LineFolding.TALL) {
                        return false;
                    }
                    prevSize.restore();
                    SqlPrettyWriter.this.newlineAndIndent();
                    node.unParse(SqlPrettyWriter.this, lprec, rprec);
                }
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    SqlNode node = list.get(i);
                    if (i == 0) {
                        this.sep(false, sepOp.name());
                    }
                    Save save = new Save();
                    node.unParse(SqlPrettyWriter.this, lprec, rprec);
                    if (i + 1 < list.size()) {
                        this.sep(false, sepOp.name());
                    }
                    if (SqlPrettyWriter.this.column() <= this.chopLimit) continue;
                    switch (this.lineFolding) {
                        case CHOP: {
                            return false;
                        }
                        case FOLD: {
                            if (this.newlineAfterOpen == SqlPrettyWriter.this.config.clauseEndsLine()) break;
                            return false;
                        }
                    }
                    save.restore();
                    SqlPrettyWriter.this.newlineAndIndent();
                    node.unParse(SqlPrettyWriter.this, lprec, rprec);
                    if (i + 1 >= list.size()) continue;
                    this.sep(false, sepOp.name());
                }
            }
            return true;
        }

        class Save {
            final int bufLength;

            Save() {
                this.bufLength = SqlPrettyWriter.this.buf.length();
            }

            void restore() {
                SqlPrettyWriter.this.buf.setLength(this.bufLength);
            }
        }
    }
}

