/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.unparse;

import kd.bos.flydb.core.sql.operator.SqlOperator;
import kd.bos.flydb.core.sql.tree.SqlCall;
import kd.bos.flydb.core.sql.tree.SqlIdentifier;
import kd.bos.flydb.core.sql.tree.SqlNode;
import kd.bos.flydb.core.sql.tree.SqlNodeList;
import kd.bos.flydb.core.sql.unparse.SqlWriter;

public final class SqlUtil {
    private SqlUtil() {
    }

    public static void unParseBinarySyntax(SqlOperator operator, SqlCall call, SqlWriter writer, int leftPrecedence, int rightPrecedence) {
        assert (call.getOperandCount() == 2);
        SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.SIMPLE);
        call.getOperand(0).unParse(writer, leftPrecedence, operator.getLeftPrecedence());
        boolean needsSpace = operator.needsSpace();
        writer.setNeedWhitespace(needsSpace);
        writer.sep(operator.name());
        writer.setNeedWhitespace(needsSpace);
        call.getOperand(1).unParse(writer, operator.getRightPrecedence(), rightPrecedence);
        writer.endList(frame);
    }

    public static void unParseFunctionSyntax(SqlOperator operator, SqlWriter writer, SqlCall call, boolean ordered) {
        writer.keyword(operator.name());
        if (call.getOperandCount() == 0) {
            switch (call.getOperator().getSyntax()) {
                case FUNCTION_ID: {
                    return;
                }
                case FUNCTION: {
                    break;
                }
            }
        }
        SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.FUN_CALL, "(", ")");
        for (SqlNode operand : call.getOperandList()) {
            if (ordered && operand instanceof SqlNodeList) {
                writer.sep("ORDER BY");
            } else {
                writer.sep(",");
            }
            operand.unParse(writer, 0, 0);
        }
        writer.endList(frame);
    }

    public static void unParseSqlIdentifierSyntax(SqlWriter writer, SqlIdentifier identifier, boolean asFunctionId) {
        SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.IDENTIFIER);
        writer.keyword(identifier.toString());
        writer.endList(frame);
    }
}

