/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.unparse;

import java.util.function.Consumer;
import kd.bos.flydb.core.sql.operator.SqlOperator;
import kd.bos.flydb.core.sql.operator.SqlOperatorImpl;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.tree.SqlNode;
import kd.bos.flydb.core.sql.tree.SqlNodeList;
import kd.bos.flydb.core.sql.unparse.SqlDialect;
import kd.bos.flydb.core.sql.unparse.SqlString;
import org.checkerframework.dataflow.qual.Pure;

public interface SqlWriter {
    public static final SqlOperator COMMA = new SqlOperatorImpl(",", SqlKind.OTHER, 2, false);

    public void reset();

    public void resetSettings();

    public SqlDialect getDialect();

    public SqlString toSqlString();

    @Pure
    public void literal(String var1);

    @Pure
    public void keyword(String var1);

    @Pure
    public void print(String var1);

    @Pure
    public void print(int var1);

    public void identifier(String var1, boolean var2);

    public void dynamicParam(int var1);

    public void fetchOffset(SqlNode var1, SqlNode var2);

    public void topN(SqlNode var1, SqlNode var2);

    public void newlineAndIndent();

    public boolean isQuoteAllIdentifiers();

    public boolean isClauseStartsLine();

    public boolean isSelectListItemsOnSeparateLines();

    public boolean isKeywordsLowerCase();

    @Pure
    public Frame startFunCall(String var1);

    @Pure
    public void endFunCall(Frame var1);

    @Pure
    public Frame startList(String var1, String var2);

    @Pure
    public Frame startList(FrameTypeEnum var1);

    @Pure
    public Frame startList(FrameType var1, String var2, String var3);

    @Pure
    public void endList(Frame var1);

    @Pure
    public SqlWriter list(FrameTypeEnum var1, Consumer<SqlWriter> var2);

    @Pure
    public SqlWriter list(FrameTypeEnum var1, SqlOperator var2, SqlNodeList var3);

    @Pure
    public void sep(String var1);

    @Pure
    public void sep(String var1, boolean var2);

    @Pure
    public void setNeedWhitespace(boolean var1);

    public int getIndentation();

    public boolean isAlwaysUseParentheses();

    public boolean inQuery();

    public static interface FrameType {
        public String getName();

        public boolean needsIndent();
    }

    public static interface Frame {
    }

    public static enum FrameTypeEnum implements FrameType
    {
        SELECT,
        SHOW,
        SIMPLE,
        PARENTHESES,
        SELECT_LIST,
        WINDOW_DECL_LIST,
        FUN_CALL,
        ORDER_BY,
        ORDER_BY_LIST,
        OFFSET,
        LIMIT,
        GROUP_BY_LIST,
        SUB_QUERY(true),
        SETOP,
        SET_VARIABLE,
        VALUES,
        FROM_LIST,
        JOIN(false),
        WHERE_LIST,
        IDENTIFIER(false),
        AS(false),
        CASE,
        OTHER;

        private final boolean needsIndent;

        private FrameTypeEnum() {
            this(true);
        }

        private FrameTypeEnum(boolean needsIndent) {
            this.needsIndent = needsIndent;
        }

        @Override
        public boolean needsIndent() {
            return this.needsIndent;
        }

        public static FrameType create(final String name) {
            return new FrameType(){

                @Override
                public String getName() {
                    return name;
                }

                @Override
                public boolean needsIndent() {
                    return true;
                }
            };
        }

        @Override
        public String getName() {
            return this.name();
        }
    }

    public static enum SubQueryStyle {
        HYDE,
        BLACK;

    }
}

