/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.util;

import java.util.List;
import kd.bos.flydb.core.sql.tree.SqlBasicCall;
import kd.bos.flydb.core.sql.tree.SqlCall;
import kd.bos.flydb.core.sql.tree.SqlDynamicParam;
import kd.bos.flydb.core.sql.tree.SqlIdentifier;
import kd.bos.flydb.core.sql.tree.SqlJoin;
import kd.bos.flydb.core.sql.tree.SqlLiteral;
import kd.bos.flydb.core.sql.tree.SqlNode;
import kd.bos.flydb.core.sql.tree.SqlNodeList;
import kd.bos.flydb.core.sql.tree.SqlOrderBy;
import kd.bos.flydb.core.sql.tree.SqlSelect;
import kd.bos.flydb.core.sql.tree.SqlSetVariable;
import kd.bos.flydb.core.sql.tree.SqlShow;
import kd.bos.flydb.core.sql.tree.SqlShowVariables;

public interface ASTVisitor<T> {
    public T visitSqlCall(SqlCall var1);

    public T visitSqlBasicCall(SqlBasicCall var1);

    public T visitSqlDynamicParam(SqlDynamicParam var1);

    public T visitSqlIdentifier(SqlIdentifier var1);

    public T visitSqlJoin(SqlJoin var1);

    public T visitSqlLiteral(SqlLiteral var1);

    public T visitSqlNodeList(SqlNodeList var1);

    public T visitSqlOrderBy(SqlOrderBy var1);

    public T visitSqlSelect(SqlSelect var1);

    public T visitSqlShow(SqlShow var1);

    public T visitSqlShowVariables(SqlShowVariables var1);

    public T visitSqlSetVariable(SqlSetVariable var1);

    default public T aggregateResult(T aggregate, T next) {
        return next;
    }

    default public boolean shouldVisitNextChild(SqlNode node, T currentResult) {
        return true;
    }

    default public T visitChildren(SqlNode node) {
        T result = this.defaultResult();
        if (node instanceof SqlCall) {
            SqlCall call = (SqlCall)node;
            List<SqlNode> operandList = call.getOperandList();
            for (int i = 0; i < call.getOperandCount() && this.shouldVisitNextChild(node, result); ++i) {
                SqlNode nextNode = operandList.get(i);
                if (nextNode == null) continue;
                Object next = nextNode.accept(this);
                result = this.aggregateResult(result, next);
            }
            return result;
        }
        if (node instanceof SqlNodeList) {
            SqlNodeList nodeList = (SqlNodeList)node;
            for (int i = 0; i < nodeList.size() && this.shouldVisitNextChild(node, result); ++i) {
                SqlNode nextNode = nodeList.get(i);
                if (nextNode == null) continue;
                Object next = nextNode.accept(this);
                result = this.aggregateResult(result, next);
            }
            return result;
        }
        return result;
    }

    default public T defaultResult() {
        return null;
    }
}

