/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class Assertions {
    private Assertions() {
    }

    public static void requireNonNullItem(List<?> list, String message) {
        for (Object item : list) {
            if (item != null) continue;
            throw new IllegalArgumentException(message);
        }
    }

    public static void requireNonDuplicateFieldName(List<String> list) {
        HashSet<String> set = new HashSet<String>(list.size());
        for (String s : list) {
            if (set.add(s)) continue;
            throw new IllegalArgumentException("Duplicate fieldName: " + s + " .");
        }
    }

    public static void requireNonDuplicate(List<String> list, DuplicateListHandle handle) {
        HashMap<String, Integer> map = new HashMap<String, Integer>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            if (map.containsKey(list.get(i))) {
                handle.duplicate(list, (Integer)map.get(list.get(i)), i);
                continue;
            }
            map.put(list.get(i), i);
        }
    }

    public static interface DuplicateListHandle {
        public void duplicate(List<String> var1, int var2, int var3);
    }
}

