/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.flydb.core.sql.type.DataType;
import kd.bos.flydb.core.sql.type.DataTypeField;

public class DataTypeSearchTrie {
    private final DataTypeSearchTrie parent;
    private final HashMap<String, DataTypeSearchTrie> children = new HashMap();
    private final String key;
    private final DataType value;

    public DataTypeSearchTrie(DataTypeSearchTrie parent, String key, DataType value) {
        this.parent = parent;
        this.key = key;
        this.value = value;
    }

    public void addChild(DataTypeSearchTrie child) {
        this.children.put(child.key, child);
    }

    public DataTypeSearchTrie findChild(String key) {
        for (Map.Entry<String, DataTypeSearchTrie> trieEntry : this.children.entrySet()) {
            if (!trieEntry.getKey().equalsIgnoreCase(key)) continue;
            return trieEntry.getValue();
        }
        return this.children.get(key);
    }

    public DataTypeSearchTrie getParent() {
        return this.parent;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public DataTypeSearchTrie findRoot() {
        DataTypeSearchTrie p = this;
        while (!p.isRoot()) {
            p = p.parent;
        }
        return p;
    }

    public DataTypeSearchTrie search(List<String> keyPath) {
        DataTypeSearchTrie r = this;
        ArrayList<String> searchPath = new ArrayList<String>(keyPath);
        if (searchPath.size() == 1) {
            searchPath.add(0, r.key);
        }
        for (int i = 0; i < searchPath.size(); ++i) {
            if (r.key.equalsIgnoreCase((String)searchPath.get(i))) {
                if (r.isLeaf()) {
                    if (searchPath.size() > i + 1) {
                        return null;
                    }
                    return r;
                }
                if (i + 1 == searchPath.size()) {
                    return r;
                }
                String nextKey = (String)searchPath.get(i + 1);
                if (nextKey.equals("*")) {
                    return r;
                }
                DataTypeSearchTrie child = r.findChild(nextKey);
                if (child != null) {
                    r = child;
                    continue;
                }
                return null;
            }
            if (!((String)searchPath.get(i)).equals("*")) continue;
            return r.parent;
        }
        return null;
    }

    public List<String> path() {
        DataTypeSearchTrie p = this;
        ArrayList<String> path = new ArrayList<String>();
        path.add(p.key);
        while (!p.isRoot()) {
            p = p.parent;
            path.add(0, p.key);
        }
        return path;
    }

    public DataType getValue() {
        return this.value;
    }

    public static DataTypeSearchTrie build(DataTypeSearchTrie parent, String key, DataType value) {
        DataTypeSearchTrie trie = new DataTypeSearchTrie(parent, key, value);
        if (parent != null) {
            parent.addChild(trie);
        }
        if (value.isStruct()) {
            for (DataTypeField dataTypeField : value.getFieldList()) {
                DataTypeSearchTrie.build(trie, dataTypeField.getName(), dataTypeField.getType());
            }
        }
        return trie;
    }
}

