/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.util;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.Temporal;
import java.util.Locale;
import kd.bos.flydb.core.sql.type.DataType;
import kd.bos.flydb.core.sql.type.DataTypeFactory;
import kd.bos.flydb.core.sql.util.Pair;

public final class KSqlTimeLiteralHandler {
    public static final DateTimeFormatter dDtf = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final DateTimeFormatter tDtf = DateTimeFormatter.ofPattern("HH:mm:ss");
    public static final DateTimeFormatter tsDtf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final DateTimeFormatter tsWithMilSecDtf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");

    public static Pair<DataType, Temporal> pair(String flag, String pattern) {
        flag = flag.toUpperCase(Locale.ENGLISH);
        pattern = KSqlTimeLiteralHandler.removeQuote(pattern);
        switch (flag) {
            case "TS": 
            case "DATETIME": {
                LocalDateTime localDateTime;
                try {
                    localDateTime = LocalDateTime.parse(pattern, tsDtf);
                }
                catch (DateTimeParseException e) {
                    localDateTime = LocalDateTime.parse(pattern, tsWithMilSecDtf);
                }
                return new Pair<DataType, Temporal>(DataTypeFactory.instance.buildDatetime(), localDateTime);
            }
            case "T": 
            case "TIME": {
                LocalTime localTime = LocalTime.parse(pattern, tDtf);
                return new Pair<DataType, Temporal>(DataTypeFactory.instance.buildTime(), localTime);
            }
            case "D": 
            case "DATE": {
                LocalDate localDate = LocalDate.parse(pattern, dDtf);
                return new Pair<DataType, Temporal>(DataTypeFactory.instance.buildDate(), localDate);
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported kSqlTimeLiteral = {%s %s},", flag, pattern));
    }

    private static String removeQuote(String pattern) {
        char[] chars = pattern.trim().toCharArray();
        int length = chars.length;
        if (length > 0) {
            StringBuilder ret = new StringBuilder(length - 2);
            for (int i = 0; i < length; ++i) {
                char ch = chars[i];
                if (ch == '\'') continue;
                ret.append(ch);
            }
            return ret.toString();
        }
        throw new UnsupportedOperationException(String.format("Unsupported pattern %s", pattern));
    }
}

