/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.util;

import java.util.AbstractList;
import java.util.List;
import java.util.Objects;

public final class Pair<T, V> {
    T type;
    V value;

    public Pair(T type, V value) {
        this.type = type;
        this.value = value;
    }

    public static <K, V> List<Pair<K, V>> zip(List<? extends K> ts, List<? extends V> vs) {
        return Pair.zip(ts, vs, true);
    }

    public static <K, V> List<Pair<K, V>> zip(List<? extends K> ts, List<? extends V> vs, boolean strict) {
        int size;
        if (strict) {
            if (ts.size() != vs.size()) {
                throw new AssertionError();
            }
            size = ts.size();
        } else {
            size = Math.min(ts.size(), vs.size());
        }
        return new ZipList<K, V>(ts, vs, size);
    }

    public static <T1, T2> Pair<T1, T2> of(T1 type, T2 value) {
        return new Pair<T1, T2>(type, value);
    }

    public T getType() {
        return this.type;
    }

    public V getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pair pair = (Pair)o;
        return Objects.equals(this.type, pair.type) && Objects.equals(this.value, pair.value);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.value);
    }

    private static class ZipList<K, V>
    extends AbstractList<Pair<K, V>> {
        private final List<? extends K> ts;
        private final List<? extends V> vs;
        private final int size;

        ZipList(List<? extends K> ts, List<? extends V> vs, int size) {
            this.ts = ts;
            this.vs = vs;
            this.size = size;
        }

        @Override
        public Pair<K, V> get(int index) {
            return Pair.of(this.ts.get(index), this.vs.get(index));
        }

        @Override
        public int size() {
            return this.size;
        }
    }
}

