/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.util;

import java.util.function.Consumer;
import kd.bos.flydb.core.sql.tree.SqlBasicCall;
import kd.bos.flydb.core.sql.tree.SqlCall;
import kd.bos.flydb.core.sql.tree.SqlDynamicParam;
import kd.bos.flydb.core.sql.tree.SqlIdentifier;
import kd.bos.flydb.core.sql.tree.SqlJoin;
import kd.bos.flydb.core.sql.tree.SqlLiteral;
import kd.bos.flydb.core.sql.tree.SqlNode;
import kd.bos.flydb.core.sql.tree.SqlNodeList;
import kd.bos.flydb.core.sql.tree.SqlOrderBy;
import kd.bos.flydb.core.sql.tree.SqlSelect;
import kd.bos.flydb.core.sql.tree.SqlSetVariable;
import kd.bos.flydb.core.sql.tree.SqlShow;
import kd.bos.flydb.core.sql.tree.SqlShowVariables;
import kd.bos.flydb.core.sql.util.ASTVisitor;

public final class SqlFormatter {
    public static String formatSql(SqlNode sqlNode) {
        StringBuilder appender = new StringBuilder();
        new Formatter(appender).visitChildren(sqlNode);
        return appender.toString();
    }

    private static class Formatter
    implements ASTVisitor<Void> {
        private final StringBuilder appender;

        public Formatter(StringBuilder appender) {
            this.appender = appender;
        }

        @Override
        public Void visitSqlCall(SqlCall node) {
            return (Void)this.visitChildren(node);
        }

        @Override
        public Void visitSqlBasicCall(SqlBasicCall node) {
            return null;
        }

        @Override
        public Void visitSqlDynamicParam(SqlDynamicParam node) {
            this.appender.append("?");
            return null;
        }

        @Override
        public Void visitSqlIdentifier(SqlIdentifier node) {
            return null;
        }

        @Override
        public Void visitSqlJoin(SqlJoin node) {
            return null;
        }

        @Override
        public Void visitSqlLiteral(SqlLiteral node) {
            return null;
        }

        @Override
        public Void visitSqlNodeList(SqlNodeList node) {
            return null;
        }

        @Override
        public Void visitSqlOrderBy(SqlOrderBy node) {
            return null;
        }

        @Override
        public Void visitSqlSelect(SqlSelect node) {
            SqlNodeList keyWords;
            this.appender.append("SELECT ");
            SqlNodeList hints = node.getOperand(10).cast(SqlNodeList.class);
            if (hints != null && hints.size() > 0) {
                this.appender.append("/*");
                this.appendNodeListWithComma(hints);
                this.appender.append("*/");
            }
            if ((keyWords = node.getOperand(0).cast(SqlNodeList.class)) != null && keyWords.size() > 0) {
                keyWords.forEach((Consumer<? super SqlNode>)((Consumer<SqlNode>)kw -> {
                    Void cfr_ignored_0 = (Void)this.visitChildren((SqlNode)kw);
                }));
            }
            SqlNodeList selectList = node.getOperand(1).cast(SqlNodeList.class);
            this.appendNodeListWithComma(selectList);
            SqlNode from = node.getOperand(2);
            if (from != null) {
                this.appender.append(" FROM ");
            }
            return null;
        }

        private void appendNodeListWithComma(SqlNodeList sqlNodeList) {
            for (int i = 0; i < sqlNodeList.size(); ++i) {
                if (i > 0) {
                    this.appender.append(',');
                }
                this.visitChildren(sqlNodeList.get(i));
            }
        }

        @Override
        public Void visitSqlShow(SqlShow sqlShow) {
            return null;
        }

        @Override
        public Void visitSqlShowVariables(SqlShowVariables sqlShowVariables) {
            return null;
        }

        @Override
        public Void visitSqlSetVariable(SqlSetVariable sqlSetVariable) {
            return null;
        }
    }
}

