/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.util;

import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.flydb.core.rex.RexInputRef;
import kd.bos.flydb.core.rex.RexNode;
import kd.bos.flydb.core.sql.tree.SqlCall;
import kd.bos.flydb.core.sql.tree.SqlIdentifier;
import kd.bos.flydb.core.sql.tree.SqlNode;
import kd.bos.flydb.core.sql.type.DataType;

public final class SqlValidateUtil {
    private SqlValidateUtil() {
    }

    public static String getAlias(SqlNode sqlNode, int ordinal) {
        switch (sqlNode.getKind()) {
            case AS: {
                return sqlNode.cast(SqlCall.class).getOperand(1).cast(SqlIdentifier.class).getSimple();
            }
            case IDENTIFIER: {
                return sqlNode.cast(SqlIdentifier.class).getLast();
            }
        }
        if (ordinal < 0) {
            return "unknown";
        }
        return "EXPR$" + ordinal;
    }

    public static String getAlias(DataType type, RexNode rexNode, int ordinal) {
        if (rexNode instanceof RexInputRef) {
            return type.getField(((RexInputRef)rexNode).getIndex()).getName();
        }
        return "EXPR$" + ordinal;
    }

    public static void renameDuplicate(List<String> names) {
        HashMap<String, AtomicInteger> duplicateNames = new HashMap<String, AtomicInteger>();
        for (int i = 0; i < names.size(); ++i) {
            String name = names.get(i);
            AtomicInteger integer = (AtomicInteger)duplicateNames.get(name);
            if (integer == null) {
                integer = new AtomicInteger(1);
                duplicateNames.put(name, integer);
                continue;
            }
            String newName = name + '$' + i;
            integer = (AtomicInteger)duplicateNames.get(newName);
            if (integer == null) {
                integer = new AtomicInteger(1);
                duplicateNames.put(newName, integer);
                names.set(i, newName);
                continue;
            }
            integer = (AtomicInteger)duplicateNames.get(name);
            int idx = integer.incrementAndGet();
            names.set(i, name + idx);
        }
    }
}

