/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.validate.impl;

import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.sql.tree.SqlBasicCall;
import kd.bos.flydb.core.sql.tree.SqlIdentifier;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.tree.SqlNode;
import kd.bos.flydb.core.sql.tree.SqlNodeList;
import kd.bos.flydb.core.sql.tree.SqlParserPosition;
import kd.bos.flydb.core.sql.validate.SqlClause;
import kd.bos.flydb.core.sql.validate.SqlValidatorScope;
import kd.bos.flydb.core.sql.validate.impl.AggFinder;
import kd.bos.flydb.core.sql.validate.impl.ExpressionValidator;

public class AggExpressionValidator
extends ExpressionValidator {
    private final SqlValidatorScope scope;
    private final SqlClause sqlClause;
    private final ExpressionValidator expressionValidator;
    private final AggFinder aggFinder;
    private SqlNodeList groupList;

    public AggExpressionValidator(SqlValidatorScope scope, SqlNodeList groupList, SqlClause sqlClause) {
        super(scope, null, sqlClause);
        this.scope = scope;
        this.sqlClause = sqlClause;
        this.groupList = groupList;
        boolean allowStar = sqlClause == SqlClause.SELECT_LIST;
        boolean allowStruct = sqlClause == SqlClause.SELECT_LIST;
        this.expressionValidator = new ExpressionValidator(scope, null, sqlClause, allowStar, allowStruct);
        this.aggFinder = new AggFinder(node -> {
            throw Exceptions.of((ErrorCode)ErrorCode.AggregateFunctionNest, (SqlParserPosition)node.getPosition(), (Object[])new Object[]{node.toSql()});
        });
        if (this.groupList == null) {
            this.groupList = new SqlNodeList(SqlParserPosition.ZERO);
        }
    }

    @Override
    public SqlNode validate(SqlNode sqlNode) {
        sqlNode = sqlNode.accept(this.expressionValidator);
        sqlNode.accept(this);
        return sqlNode;
    }

    @Override
    public SqlNode visitSqlIdentifier(SqlIdentifier node) {
        for (SqlNode sqlNode : this.groupList) {
            if (!sqlNode.equalsOnExpression(node)) continue;
            return node;
        }
        throw Exceptions.of((ErrorCode)ErrorCode.ExpressionNotBelongGroup, (SqlParserPosition)node.getPosition(), (Object[])new Object[]{node.toSql()});
    }

    @Override
    public SqlNode visitSqlBasicCall(SqlBasicCall node) {
        if (node.getKind().isBelong(SqlKind.AGGREGATE_FUNCTIONS)) {
            for (SqlNode sqlNode : node.getOperandList()) {
                sqlNode.accept(this.aggFinder);
            }
            return node;
        }
        for (SqlNode sqlNode : this.groupList) {
            if (!sqlNode.equalsOnExpression(node)) continue;
            return node;
        }
        try {
            return super.visitSqlBasicCall(node);
        }
        catch (Exception exception) {
            throw Exceptions.of((ErrorCode)ErrorCode.ExpressionNotBelongGroup, (SqlParserPosition)node.getPosition(), (Object[])new Object[]{node.toSql()});
        }
    }
}

