/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.validate.impl;

import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.flydb.core.sql.tree.SqlBasicCall;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.tree.SqlNode;
import kd.bos.flydb.core.sql.util.ASTTraver;

public class AggFinder
extends ASTTraver {
    private AggFindCallback findCallback;

    public AggFinder(AggFindCallback findCallback) {
        this.findCallback = findCallback;
    }

    @Override
    public SqlNode visitSqlBasicCall(SqlBasicCall node) {
        if (node.getKind().isBelong(SqlKind.AGGREGATE_FUNCTIONS) && this.findCallback != null) {
            this.findCallback.onMatch(node);
        }
        return (SqlNode)super.visitSqlBasicCall(node);
    }

    public static class HasContainerAggCall
    implements AggFindCallback {
        private final AtomicBoolean tag = new AtomicBoolean(false);

        public boolean isAgg() {
            return this.tag.get();
        }

        @Override
        public void onMatch(SqlNode node) {
            this.tag.set(true);
        }
    }

    public static interface AggFindCallback {
        public void onMatch(SqlNode var1);
    }
}

