/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.validate.impl;

import java.util.List;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.Context;
import kd.bos.flydb.core.Contexts;
import kd.bos.flydb.core.sql.validate.AuthorityValidator;
import kd.bos.flydb.manager.SuperQueryService;
import kd.bos.flydb.manager.metadata.PrivilegeType;

public class AuthorityValidatorImpl
implements AuthorityValidator {
    private final SuperQueryService manager = SuperQueryService.create();

    @Override
    public void validateSchema(PrivilegeType[] privileges) {
        Context context = Contexts.get();
        boolean check = this.manager.check(context.getCurrentUserId(), privileges, context.getCurrentDatabase(), context.getCurrentSchema());
        if (!check) {
            throw Exceptions.of((ErrorCode)ErrorCode.SchemaNotExist, (Object[])new Object[]{context.getCurrentDatabase(), context.getCurrentSchema()});
        }
    }

    @Override
    public void validateSchema(String schema, PrivilegeType[] privileges) {
        Context context = Contexts.get();
        boolean check = this.manager.check(context.getCurrentUserId(), privileges, context.getCurrentDatabase(), schema);
        if (!check) {
            throw Exceptions.of((ErrorCode)ErrorCode.SchemaNotExist, (Object[])new Object[]{context.getCurrentDatabase(), schema});
        }
    }

    @Override
    public void validateSchema(String database, String schema, PrivilegeType[] privileges) {
        Context context = Contexts.get();
        boolean check = this.manager.check(context.getCurrentUserId(), privileges, database, schema);
        if (!check) {
            throw Exceptions.of((ErrorCode)ErrorCode.SchemaNotExist, (Object[])new Object[]{database, schema});
        }
    }

    @Override
    public void validateTable(String database, String schema, List<String> tableName) {
        if (tableName == null || tableName.isEmpty()) {
            throw Exceptions.of((ErrorCode)ErrorCode.Unexpected1, (Object[])new Object[]{"table name is null or empty"});
        }
        for (String table : tableName) {
            boolean exist = this.manager.exist(database, schema, table);
            if (exist) continue;
            throw Exceptions.of((ErrorCode)ErrorCode.TableNotExist, (Object[])new Object[]{database + '.' + schema + '.' + table});
        }
    }
}

