/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.validate.impl;

import java.util.List;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.sql.tree.SqlBasicCall;
import kd.bos.flydb.core.sql.tree.SqlDynamicParam;
import kd.bos.flydb.core.sql.tree.SqlIdentifier;
import kd.bos.flydb.core.sql.tree.SqlJoin;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.tree.SqlLiteral;
import kd.bos.flydb.core.sql.tree.SqlNode;
import kd.bos.flydb.core.sql.tree.SqlNodeList;
import kd.bos.flydb.core.sql.tree.SqlOrderBy;
import kd.bos.flydb.core.sql.tree.SqlParserPosition;
import kd.bos.flydb.core.sql.tree.SqlSelect;
import kd.bos.flydb.core.sql.tree.SqlShow;
import kd.bos.flydb.core.sql.type.DataType;
import kd.bos.flydb.core.sql.util.BaseASTVisitor;
import kd.bos.flydb.core.sql.validate.SqlValidator;
import kd.bos.flydb.core.sql.validate.SqlValidatorScope;

public class DataTypeInfer
extends BaseASTVisitor<DataType> {
    private final SqlValidator sqlValidator;
    private final SqlValidatorScope scope;

    public DataTypeInfer(SqlValidator sqlValidator, SqlValidatorScope scope) {
        this.sqlValidator = sqlValidator;
        this.scope = scope;
    }

    @Override
    public DataType visitSqlBasicCall(SqlBasicCall node) {
        if (node.getKind() == SqlKind.AS) {
            return node.getOperand(0).accept(this);
        }
        return node.getOperator().inferReturnType(this.sqlValidator, this.scope, node);
    }

    @Override
    public DataType visitSqlDynamicParam(SqlDynamicParam node) {
        return this.sqlValidator.getTypeFactory().buildUnknownType();
    }

    @Override
    public DataType visitSqlIdentifier(SqlIdentifier node) {
        List<SqlValidatorScope.LookupPath> lookupPaths = this.scope.lookupScopeChild(node);
        assert (lookupPaths.size() == 1);
        return lookupPaths.get((int)0).dataType;
    }

    @Override
    public DataType visitSqlLiteral(SqlLiteral node) {
        return node.getDataType();
    }

    @Override
    public DataType visitSqlNodeList(SqlNodeList node) {
        if (!node.isEmpty()) {
            for (SqlNode sqlNode : node) {
                this.sqlValidator.inferDataType(sqlNode, this.scope);
            }
        }
        return this.sqlValidator.getTypeFactory().buildUnknownType();
    }

    @Override
    public DataType visitSqlShow(SqlShow node) {
        return this.sqlValidator.getNamespace(node).getDataType();
    }

    @Override
    public DataType visitSqlJoin(SqlJoin node) {
        throw Exceptions.of((ErrorCode)ErrorCode.Unexpected, (SqlParserPosition)node.getPosition(), (Object[])new Object[0]);
    }

    @Override
    public DataType visitSqlOrderBy(SqlOrderBy node) {
        return this.sqlValidator.getNamespace(node).getDataType();
    }

    @Override
    public DataType visitSqlSelect(SqlSelect node) {
        return this.sqlValidator.getNamespace(node).getDataType();
    }
}

