/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.validate.impl;

import java.util.ArrayList;
import java.util.List;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.sql.tree.SqlBasicCall;
import kd.bos.flydb.core.sql.tree.SqlIdentifier;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.tree.SqlNode;
import kd.bos.flydb.core.sql.tree.SqlNodeList;
import kd.bos.flydb.core.sql.tree.SqlOrderBy;
import kd.bos.flydb.core.sql.tree.SqlParserPosition;
import kd.bos.flydb.core.sql.tree.SqlSelect;
import kd.bos.flydb.core.sql.util.ASTTraver;
import kd.bos.flydb.core.sql.validate.SqlClause;
import kd.bos.flydb.core.sql.validate.SqlValidatorScope;

public class ExpressionValidator
extends ASTTraver {
    private final SqlValidatorScope scope;
    private final SqlKind[] unsupportedSqlKinds;
    private final SqlClause sqlClause;
    private boolean allowStar = false;
    private boolean allowStruct = false;

    public ExpressionValidator(SqlValidatorScope scope, SqlKind[] unsupportedSqlKinds, SqlClause sqlClause) {
        this.scope = scope;
        this.unsupportedSqlKinds = unsupportedSqlKinds;
        this.sqlClause = sqlClause;
    }

    public ExpressionValidator(SqlValidatorScope scope, SqlKind[] unsupportedSqlKinds, SqlClause sqlClause, boolean allowStar, boolean allowStruct) {
        this.scope = scope;
        this.unsupportedSqlKinds = unsupportedSqlKinds;
        this.sqlClause = sqlClause;
        this.allowStar = allowStar;
        this.allowStruct = allowStruct;
    }

    public SqlNode validate(SqlNode sqlNode) {
        return sqlNode.accept(this);
    }

    @Override
    public SqlNode visitSqlIdentifier(SqlIdentifier node) {
        if (node.isStar()) {
            if (!this.allowStar) {
                throw Exceptions.of((ErrorCode)ErrorCode.SyntaxError, (SqlParserPosition)node.getPosition(), (Object[])new Object[]{node.toString()});
            }
            return node;
        }
        List<SqlValidatorScope.LookupPath> lookupPaths = this.scope.lookupScopeChild(node);
        if (lookupPaths.size() == 0) {
            throw Exceptions.of((ErrorCode)ErrorCode.ColumnNotExist, (SqlParserPosition)node.getPosition(), (Object[])new Object[]{node.toString()});
        }
        if (lookupPaths.size() == 1) {
            if (lookupPaths.get((int)0).dataType.isStruct() && !this.allowStruct) {
                throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedStructField, (SqlParserPosition)node.getPosition(), (Object[])new Object[]{this.sqlClause});
            }
            return new SqlIdentifier(node.getPosition(), lookupPaths.get((int)0).path);
        }
        throw Exceptions.of((ErrorCode)ErrorCode.ColumnAmbiguous, (SqlParserPosition)node.getPosition(), (Object[])new Object[]{node.toString()});
    }

    @Override
    public SqlNode visitSqlBasicCall(SqlBasicCall node) {
        if (node.getKind() == SqlKind.AS) {
            SqlBasicCall call = node.cast(SqlBasicCall.class);
            SqlNode left = call.getOperand(0);
            SqlNode right = call.getOperand(1);
            return new SqlBasicCall(call.getPosition(), call.getKind(), call.getOperator(), left.accept(this), right);
        }
        if (this.unsupportedSqlKinds != null && node.getKind().isBelong(this.unsupportedSqlKinds)) {
            throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedOperator, (Object[])new Object[]{node.getOperator().name(), this.sqlClause});
        }
        ArrayList<SqlNode> operands = new ArrayList<SqlNode>(node.getOperandCount());
        for (SqlNode sqlNode : node.getOperandList()) {
            operands.add(sqlNode.accept(this));
        }
        return new SqlBasicCall(node.getPosition(), node.getKind(), node.getOperator(), operands);
    }

    @Override
    public SqlNode visitSqlOrderBy(SqlOrderBy node) {
        return this.scope.getSqlValidator().validate(node);
    }

    @Override
    public SqlNode visitSqlSelect(SqlSelect node) {
        return this.scope.getSqlValidator().validate(node);
    }

    @Override
    public SqlNode visitSqlNodeList(SqlNodeList node) {
        SqlNodeList newList = new SqlNodeList(node.getPosition());
        for (SqlNode sqlNode : node) {
            newList.add(sqlNode.accept(this));
        }
        return newList;
    }
}

