/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.validate.impl;

import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.sql.tree.SqlBasicCall;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.tree.SqlNode;
import kd.bos.flydb.core.sql.tree.SqlOrderBy;
import kd.bos.flydb.core.sql.tree.SqlParserPosition;
import kd.bos.flydb.core.sql.tree.SqlSelect;
import kd.bos.flydb.core.sql.validate.SqlClause;
import kd.bos.flydb.core.sql.validate.SqlValidatorScope;
import kd.bos.flydb.core.sql.validate.impl.ExpressionValidator;

public class JoinExpressionValidator
extends ExpressionValidator {
    private static final SqlKind[] allowSqlKind = new SqlKind[]{SqlKind.AND, SqlKind.OR, SqlKind.EQUALS};

    public JoinExpressionValidator(SqlValidatorScope scope) {
        super(scope, null, SqlClause.ON);
    }

    @Override
    public SqlNode visitSqlBasicCall(SqlBasicCall node) {
        if (!node.getKind().isBelong(allowSqlKind)) {
            throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedOperator, (SqlParserPosition)node.getPosition(), (Object[])new Object[]{node.getOperator().name(), "JOIN"});
        }
        return super.visitSqlBasicCall(node);
    }

    @Override
    public SqlNode visitSqlOrderBy(SqlOrderBy node) {
        throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedSubQuery, (Object[])new Object[]{"JOIN"});
    }

    @Override
    public SqlNode visitSqlSelect(SqlSelect node) {
        throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedSubQuery, (Object[])new Object[]{"JOIN"});
    }
}

