/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.validate.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.sql.tree.SqlIdentifier;
import kd.bos.flydb.core.sql.tree.SqlNode;
import kd.bos.flydb.core.sql.tree.SqlNodeList;
import kd.bos.flydb.core.sql.tree.SqlParserPosition;
import kd.bos.flydb.core.sql.type.DataType;
import kd.bos.flydb.core.sql.type.DataTypeField;
import kd.bos.flydb.core.sql.util.DataTypeSearchTrie;
import kd.bos.flydb.core.sql.util.ListUtil;
import kd.bos.flydb.core.sql.validate.ScopeChild;
import kd.bos.flydb.core.sql.validate.SqlValidator;
import kd.bos.flydb.core.sql.validate.SqlValidatorNamespace;
import kd.bos.flydb.core.sql.validate.SqlValidatorScope;
import kd.bos.flydb.core.sql.validate.impl.DelegateScope;

public abstract class ListScope
extends DelegateScope {
    private final List<ScopeChild> children = new ArrayList<ScopeChild>();

    public ListScope(SqlValidatorScope parent, SqlValidator validator, SqlNode sqlNode) {
        super(parent, validator, sqlNode);
    }

    @Override
    public SqlIdentifier fullyQualifyTable(SqlIdentifier sqlIdentifier) {
        return null;
    }

    @Override
    public SqlIdentifier fullyQualifyColumn(SqlIdentifier sqlIdentifier) {
        return null;
    }

    @Override
    public void addChild(String alias, SqlValidatorNamespace namespace) {
        this.children.add(new ScopeChild(this.children.size(), alias, namespace));
    }

    public List<String> getChildrenNameList() {
        return this.children.stream().map(ScopeChild::getAlias).collect(Collectors.toList());
    }

    @Override
    public List<SqlValidatorScope.LookupPath> lookupScopeChild(SqlIdentifier sqlIdentifier) {
        ArrayList<SqlValidatorScope.LookupPath> list = new ArrayList<SqlValidatorScope.LookupPath>(this.children.size());
        for (ScopeChild child : this.children) {
            DataTypeSearchTrie trie = DataTypeSearchTrie.build(null, child.getAlias(), child.getNs().getDataType());
            DataTypeSearchTrie r = trie.search(sqlIdentifier.getNames());
            if (r == null) continue;
            list.add(new SqlValidatorScope.LookupPath(child, r.getValue(), r.path()));
        }
        if (list.isEmpty()) {
            for (ScopeChild child : this.children) {
                DataType dataType = child.getNs().getDataType();
                if (!dataType.isStruct()) continue;
                for (DataTypeField dataTypeField : dataType.getFieldList()) {
                    DataTypeSearchTrie trie = DataTypeSearchTrie.build(null, dataTypeField.getName(), dataTypeField.getType());
                    DataTypeSearchTrie r = trie.search(sqlIdentifier.getNames());
                    if (r == null) continue;
                    ArrayList<String> path = new ArrayList<String>(r.path().size() + 1);
                    path.add(child.getAlias());
                    path.addAll(r.path());
                    list.add(new SqlValidatorScope.LookupPath(child, r.getValue(), path));
                }
            }
        }
        if (list.isEmpty()) {
            return super.lookupScopeChild(sqlIdentifier);
        }
        return list;
    }

    @Override
    public SqlNode expanderStar(SqlIdentifier identifier) {
        SqlNodeList nodeList = new SqlNodeList(identifier.getPosition());
        if (identifier.isSimpleStar()) {
            for (ScopeChild child : this.children) {
                this.expandDataType(nodeList, Lists.newArrayList((Object[])new String[]{child.getAlias()}), child.getNs().getDataType());
            }
        } else {
            List<SqlValidatorScope.LookupPath> lookupPathList;
            List<String> names = identifier.getNames();
            for (int i = 0; i < names.size(); ++i) {
                if (!names.get(i).equals("*")) continue;
                if (names.size() <= i + 1) break;
                throw Exceptions.of((ErrorCode)ErrorCode.SyntaxError2, (Object[])new Object[]{String.join((CharSequence)".", names)});
            }
            if ((lookupPathList = this.lookupScopeChild(identifier)).size() > 1) {
                throw Exceptions.of((ErrorCode)ErrorCode.ColumnAmbiguous, (SqlParserPosition)identifier.getPosition(), (Object[])new Object[]{identifier.toString()});
            }
            if (lookupPathList.size() == 0) {
                throw Exceptions.of((ErrorCode)ErrorCode.ColumnNotExist, (SqlParserPosition)identifier.getPosition(), (Object[])new Object[]{identifier.toString()});
            }
            SqlValidatorScope.LookupPath lookupPath = lookupPathList.get(0);
            this.expandDataType(nodeList, names, lookupPath.dataType);
        }
        return nodeList;
    }

    private void expandDataType(SqlNodeList sqlNodeList, List<String> parentName, DataType dataType) {
        if (dataType.isStruct()) {
            for (DataTypeField dataTypeField : dataType.getFieldList()) {
                this.expandDataTypeField(sqlNodeList, parentName, dataTypeField);
            }
        } else {
            throw Exceptions.of((ErrorCode)ErrorCode.InnerUnexpected_NamespaceRequireStructType, (Object[])new Object[0]);
        }
    }

    private void expandDataTypeField(SqlNodeList sqlNodeList, List<String> parent, DataTypeField field) {
        DataType dataType = field.getType();
        if (parent.get(parent.size() - 1).equals("*")) {
            parent.remove(parent.size() - 1);
        }
        List<String> namePath = ListUtil.concatList(parent, field.getName());
        if (dataType.isStruct()) {
            for (DataTypeField dataTypeField : dataType.getFieldList()) {
                this.expandDataTypeField(sqlNodeList, namePath, dataTypeField);
            }
        } else {
            SqlIdentifier identifier = new SqlIdentifier(sqlNodeList.getPosition(), namePath);
            sqlNodeList.add(identifier);
            this.getSqlValidator().setValidateNodeType(identifier, dataType);
        }
    }
}

