/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.validate.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.flydb.common.exception.CoreException;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.schema.Schema;
import kd.bos.flydb.core.schema.SchemaFactory;
import kd.bos.flydb.core.schema.Table;
import kd.bos.flydb.core.schema.virtual.InnerVirtualTable;
import kd.bos.flydb.core.schema.virtual.InnerVirtualTableInfo;
import kd.bos.flydb.core.sql.tree.SqlNode;
import kd.bos.flydb.core.sql.validate.SchemaReader;
import kd.bos.flydb.core.sql.validate.impl.SqlNodeOptimizer;
import kd.bos.flydb.core.util.SchemaUtils;

public class SchemaReaderImpl
implements SchemaReader {
    private final SchemaFactory schemaFactory;
    private SqlNode sqlNode;

    public SchemaReaderImpl(SchemaFactory schemaFactory) {
        this.schemaFactory = schemaFactory;
    }

    private Table getTable(List<String> names) {
        Schema schema;
        if (names.size() == 1) {
            return null;
        }
        try {
            schema = this.schemaFactory.getSchema(names.get(0));
        }
        catch (CoreException coreException) {
            if (coreException.getVendorCode() == ErrorCode.SchemaNotExist.vendorCode) {
                return null;
            }
            throw coreException;
        }
        if (schema == null) {
            return null;
        }
        return schema.getTable(names.subList(1, names.size()));
    }

    @Override
    public Table resolvedTable(List<String> names) {
        ArrayList<String> candidate = new ArrayList<String>(names);
        Table table = this.getTable(candidate);
        if (table == null) {
            candidate.clear();
            candidate.add(SchemaUtils.getCurrentSchemaOnContext());
            candidate.addAll(names);
            table = this.getTable(candidate);
        }
        if (table == null) {
            String tableName = String.join((CharSequence)".", names);
            if (tableName.equals("$$inner_virtual_table$$")) {
                InnerVirtualTableInfo innerVirtualTableInfo;
                Map<SqlNode, InnerVirtualTableInfo> sqlNodeInnerVirtualTableMap = SqlNodeOptimizer.instance.getSqlNodeInnerVirtualTableInfoMap();
                if (this.sqlNode != null && (innerVirtualTableInfo = sqlNodeInnerVirtualTableMap.remove(this.sqlNode)) != null) {
                    return new InnerVirtualTable(tableName, innerVirtualTableInfo.getDataType(), innerVirtualTableInfo.getInNodeList());
                }
            }
            throw Exceptions.of((ErrorCode)ErrorCode.TableNotExist, (Object[])new Object[]{tableName});
        }
        table.validate();
        return table;
    }

    @Override
    public void setSqlNode(SqlNode sqlNode) {
        this.sqlNode = sqlNode;
    }
}

