/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.validate.impl;

import java.util.List;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.sql.tree.SqlCall;
import kd.bos.flydb.core.sql.tree.SqlNode;
import kd.bos.flydb.core.sql.tree.SqlParserPosition;
import kd.bos.flydb.core.sql.type.DataType;
import kd.bos.flydb.core.sql.validate.SqlValidator;
import kd.bos.flydb.core.sql.validate.impl.DelegateNamespace;

public class SetopNamespace
extends DelegateNamespace {
    private SqlCall call;
    private DataType dataType;

    public SetopNamespace(SqlValidator validator, SqlCall call) {
        super(validator, call);
        this.call = call;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    @Override
    public void validate() {
        switch (this.call.getKind()) {
            case UNION: {
                List<SqlNode> operandList = this.call.getOperandList();
                for (SqlNode sqlNode : operandList) {
                    sqlNode.validate(this.validator, this.getSqlValidator().getScope(sqlNode));
                }
                if (this.dataType != null) break;
                this.dataType = this.validator.inferDataType(this.call, this.getSqlValidator().getScope(this.call));
                break;
            }
            case EXPECT: 
            case INTERSECT: {
                throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedSetOp, (SqlParserPosition)this.call.getPosition(), (Object[])new Object[]{this.call.getKind().getName()});
            }
            default: {
                throw new AssertionError((Object)("Not a query: " + (Object)((Object)this.call.getKind())));
            }
        }
    }
}

