/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.validate.impl;

import kd.bos.flydb.core.sql.operator.SqlOperator;
import kd.bos.flydb.core.sql.operator.SqlOperators;
import kd.bos.flydb.core.sql.operator.UnresolvedFunctionOperator;
import kd.bos.flydb.core.sql.tree.SqlBasicCall;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.tree.SqlNode;
import kd.bos.flydb.core.sql.tree.SqlNodeList;
import kd.bos.flydb.core.sql.tree.SqlOrderBy;
import kd.bos.flydb.core.sql.tree.SqlSelect;
import kd.bos.flydb.core.sql.util.ASTTraver;

public class SqlNodeRewrite {
    public static final SqlNodeRewrite instance = new SqlNodeRewrite();
    private final Rewriter rewriter = new Rewriter();

    public SqlNode apply(SqlNode sqlNode) {
        return sqlNode.accept(this.rewriter);
    }

    private static class Rewriter
    extends ASTTraver {
        private Rewriter() {
        }

        @Override
        public SqlNode visitSqlBasicCall(SqlBasicCall node) {
            for (int i = 0; i < node.getOperandList().size(); ++i) {
                SqlNode sqlNode = node.getOperand(i);
                if (sqlNode == null) continue;
                node.setOperand(i, sqlNode.accept(this));
            }
            if (node.getKind() == SqlKind.UNRESOLVED_FUNCTION) {
                UnresolvedFunctionOperator unresolvedOperator = (UnresolvedFunctionOperator)node.getOperator();
                SqlOperator functionOperator = SqlOperators.func(unresolvedOperator.name());
                node.setOperator(functionOperator);
            }
            return node;
        }

        @Override
        public SqlNode visitSqlOrderBy(SqlOrderBy node) {
            SqlSelect select;
            SqlNodeList orderByList;
            SqlNode query = node.getOperand(0);
            if (query instanceof SqlSelect && (orderByList = (SqlNodeList)(select = (SqlSelect)query).getOperand(7)) == null) {
                select.setOperand(7, node.getOperand(1));
                select.setOperand(8, node.getOperand(2));
                select.setOperand(9, node.getOperand(3));
                this.visitSqlSelect(select);
                return select;
            }
            return (SqlNode)super.visitSqlOrderBy(node);
        }
    }
}

