/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.validate.impl;

import kd.bos.flydb.core.schema.SchemaFactory;
import kd.bos.flydb.core.sql.validate.AuthorityValidator;
import kd.bos.flydb.core.sql.validate.SecurityRuleFinder;
import kd.bos.flydb.core.sql.validate.SqlValidateConfig;
import kd.bos.flydb.core.sql.validate.SqlValidator;
import kd.bos.flydb.core.sql.validate.impl.SqlValidatorImpl;

public class SqlValidatorFactory {
    public static SqlValidator newValidator(SqlValidateConfig config) {
        AuthorityValidator authorityValidator = (AuthorityValidator)SqlValidatorFactory.newInstance(config.getAuthorityValidatorClassName());
        SecurityRuleFinder securityRuleFinder = (SecurityRuleFinder)SqlValidatorFactory.newInstance(config.getSecurityRuleFinderClassName());
        SchemaFactory schemaFactory = (SchemaFactory)SqlValidatorFactory.newInstance(config.getSchemaFactoryClassName());
        return new SqlValidatorImpl(config, securityRuleFinder, authorityValidator, schemaFactory);
    }

    private static Object newInstance(String className) {
        try {
            return Class.forName(className).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }
}

