/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.validate.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.flydb.common.ServerConfig;
import kd.bos.flydb.common.config.Option;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.Contexts;
import kd.bos.flydb.core.ExecutorManager;
import kd.bos.flydb.core.ExecutorSupplier;
import kd.bos.flydb.core.schema.FormAttribute;
import kd.bos.flydb.core.schema.SchemaFactory;
import kd.bos.flydb.core.schema.Table;
import kd.bos.flydb.core.schema.metadata.MetadataTable;
import kd.bos.flydb.core.schema.metadata.MetadataTableFactory;
import kd.bos.flydb.core.sql.operator.OperandTypeInference;
import kd.bos.flydb.core.sql.operator.SqlOperators;
import kd.bos.flydb.core.sql.operator.SqlSetOperator;
import kd.bos.flydb.core.sql.tree.SqlBasicCall;
import kd.bos.flydb.core.sql.tree.SqlCall;
import kd.bos.flydb.core.sql.tree.SqlConditionType;
import kd.bos.flydb.core.sql.tree.SqlDynamicParam;
import kd.bos.flydb.core.sql.tree.SqlIdentifier;
import kd.bos.flydb.core.sql.tree.SqlJoin;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.tree.SqlLiteral;
import kd.bos.flydb.core.sql.tree.SqlNode;
import kd.bos.flydb.core.sql.tree.SqlNodeList;
import kd.bos.flydb.core.sql.tree.SqlOrderBy;
import kd.bos.flydb.core.sql.tree.SqlParserPosition;
import kd.bos.flydb.core.sql.tree.SqlSelect;
import kd.bos.flydb.core.sql.tree.SqlSetVariable;
import kd.bos.flydb.core.sql.tree.SqlShow;
import kd.bos.flydb.core.sql.tree.SqlShowVariables;
import kd.bos.flydb.core.sql.tree.SqlUse;
import kd.bos.flydb.core.sql.type.DataType;
import kd.bos.flydb.core.sql.type.DataTypeFactory;
import kd.bos.flydb.core.sql.type.SqlTypeName;
import kd.bos.flydb.core.sql.type.TupleDataType;
import kd.bos.flydb.core.sql.type.TypeCoercion;
import kd.bos.flydb.core.sql.util.ASTTraver;
import kd.bos.flydb.core.sql.util.Assertions;
import kd.bos.flydb.core.sql.util.IdPair;
import kd.bos.flydb.core.sql.util.SqlValidateUtil;
import kd.bos.flydb.core.sql.validate.AuthorityValidator;
import kd.bos.flydb.core.sql.validate.SchemaReader;
import kd.bos.flydb.core.sql.validate.SecurityRuleFinder;
import kd.bos.flydb.core.sql.validate.SqlClause;
import kd.bos.flydb.core.sql.validate.SqlValidateConfig;
import kd.bos.flydb.core.sql.validate.SqlValidator;
import kd.bos.flydb.core.sql.validate.SqlValidatorNamespace;
import kd.bos.flydb.core.sql.validate.SqlValidatorScope;
import kd.bos.flydb.core.sql.validate.impl.AggExpressionValidator;
import kd.bos.flydb.core.sql.validate.impl.AggFinder;
import kd.bos.flydb.core.sql.validate.impl.AggregateSelectScope;
import kd.bos.flydb.core.sql.validate.impl.DataTypeInfer;
import kd.bos.flydb.core.sql.validate.impl.EmptyScope;
import kd.bos.flydb.core.sql.validate.impl.ExpressionValidator;
import kd.bos.flydb.core.sql.validate.impl.JoinExpressionValidator;
import kd.bos.flydb.core.sql.validate.impl.JoinNamespace;
import kd.bos.flydb.core.sql.validate.impl.JoinScope;
import kd.bos.flydb.core.sql.validate.impl.ListScope;
import kd.bos.flydb.core.sql.validate.impl.SchemaReaderImpl;
import kd.bos.flydb.core.sql.validate.impl.SelectNamespace;
import kd.bos.flydb.core.sql.validate.impl.SetopNamespace;
import kd.bos.flydb.core.sql.validate.impl.ShowScope;
import kd.bos.flydb.core.sql.validate.impl.SqlGroupByScope;
import kd.bos.flydb.core.sql.validate.impl.SqlHavingScope;
import kd.bos.flydb.core.sql.validate.impl.SqlNodeOptimizer;
import kd.bos.flydb.core.sql.validate.impl.SqlNodeRewrite;
import kd.bos.flydb.core.sql.validate.impl.SqlOrderByScope;
import kd.bos.flydb.core.sql.validate.impl.SqlSelectScope;
import kd.bos.flydb.core.sql.validate.impl.TableNamespace;
import kd.bos.flydb.core.util.SchemaUtils;
import kd.bos.flydb.manager.metadata.PrivilegeType;

public class SqlValidatorImpl
implements SqlValidator {
    private static final Set<String> allowSetVariables = new HashSet<String>();
    private final SqlValidateConfig config;
    private final SecurityRuleFinder securityRuleFinder;
    private final AuthorityValidator authorityValidator;
    private final SchemaReader schemaReader;
    private final DataTypeFactory dataTypeFactory = DataTypeFactory.instance;
    private final TypeCoercion typeCoercion = new TypeCoercion();
    private final HashMap<IdPair<SqlNode, SqlClause>, SqlValidatorScope> clauseScopes = new HashMap();
    private final IdentityHashMap<SqlNode, SqlValidatorScope> scopes = new IdentityHashMap();
    private final IdentityHashMap<SqlNode, SqlValidatorNamespace> namespaces = new IdentityHashMap();
    private final IdentityHashMap<SqlNode, DataType> nodeTypes = new IdentityHashMap();
    private int joinCount = 0;

    public SqlValidatorImpl(SqlValidateConfig config, SecurityRuleFinder securityRuleFinder, AuthorityValidator authorityValidator, SchemaFactory schemaFactory) {
        this.config = config;
        this.securityRuleFinder = securityRuleFinder;
        this.authorityValidator = authorityValidator;
        this.schemaReader = new SchemaReaderImpl(schemaFactory);
    }

    @Override
    public SqlNode validate(SqlNode sqlNode) {
        sqlNode = SqlNodeRewrite.instance.apply(sqlNode);
        EmptyScope emptyScope = new EmptyScope(this, sqlNode);
        if (sqlNode.isBelong(SqlKind.TOP_LEVEL)) {
            sqlNode = SqlNodeOptimizer.instance.optimize(sqlNode);
            this.registerQuery(sqlNode, emptyScope, null, null);
        } else if (sqlNode.isBelong(SqlKind.SHOW)) {
            this.registerShow(sqlNode, emptyScope, null);
        } else if (!sqlNode.getKind().isBelong(SqlKind.TOP_LEVEL_NONE_REGISTER)) {
            throw Exceptions.of((ErrorCode)ErrorCode.InnerUnexpected_NotRootNode, (Object[])new Object[0]);
        }
        sqlNode.validate(this, emptyScope);
        return sqlNode;
    }

    private void registerQuery(SqlNode node, SqlValidatorScope scope, SqlValidatorScope usingScope, String alias) {
        Objects.requireNonNull(node, "topNode must be not null");
        Objects.requireNonNull(scope, "scope must be not null");
        switch (node.getKind()) {
            case SELECT: {
                SqlSelect select = (SqlSelect)node;
                if (usingScope == null) {
                    usingScope = new SqlSelectScope(scope, this, node);
                }
                this.registerNamespace(select, new SelectNamespace(this, select));
                if (select.getOperand(2) == null) break;
                this.registerFrom(select.getOperand(2), alias, scope, usingScope);
                this.registerClauseScope(node, SqlClause.WHERE, usingScope);
                if (select.getOperand(4) != null) {
                    SqlGroupByScope groupByScope = new SqlGroupByScope(usingScope, this, select);
                    this.registerClauseScope(select, SqlClause.GROUP_BY, groupByScope);
                    usingScope = new AggregateSelectScope(usingScope, this, select);
                }
                if (select.getOperand(5) != null) {
                    SqlHavingScope havingScope = new SqlHavingScope(usingScope, this, select);
                    this.registerClauseScope(select, SqlClause.HAVING, havingScope);
                    if (!(usingScope instanceof AggregateSelectScope)) {
                        usingScope = new AggregateSelectScope(usingScope, this, select);
                    }
                }
                if (select.getOperand(7) != null) {
                    SqlOrderByScope orderByScope = new SqlOrderByScope(usingScope, this, select);
                    this.registerClauseScope(select, SqlClause.ORDER_BY, orderByScope);
                }
                this.registerClauseScope(select, SqlClause.SELECT_LIST, usingScope);
                if (this.isAgg(select) && !(usingScope instanceof AggregateSelectScope)) {
                    usingScope = new AggregateSelectScope(usingScope, this, select);
                }
                this.scopes.put(select, usingScope);
                break;
            }
            case UNION: {
                this.registerSetop(node, scope);
                break;
            }
            default: {
                throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedCommand, (Object[])new Object[]{node.getKind().name()});
            }
        }
    }

    private void registerSetop(SqlNode node, SqlValidatorScope scope) {
        SqlCall call = (SqlCall)node;
        SetopNamespace setopNamespace = new SetopNamespace((SqlValidator)this, call);
        this.registerNamespace(call, setopNamespace);
        this.scopes.put(call, scope);
        call.getOperandList().forEach(select -> this.registerQuery((SqlNode)select, scope, null, null));
    }

    private void registerShow(SqlNode showNode, SqlValidatorScope scope, SqlValidatorScope usingScope) {
        SqlShow sqlShow = (SqlShow)showNode;
        if (usingScope == null) {
            usingScope = new ShowScope(scope, this, sqlShow);
        }
        MetadataTable table = MetadataTableFactory.create(showNode.getKind(), this.config);
        TableNamespace ns = new TableNamespace((SqlValidator)this, sqlShow);
        ns.setTable(table);
        ns.setTableName(table.getName());
        ns.setDataType(table.getDataType());
        usingScope.addChild(String.join((CharSequence)".", table.getName()), ns);
        this.registerNamespace(sqlShow, ns);
        this.registerClauseScope(sqlShow, SqlClause.WHERE, usingScope);
        this.scopes.put(showNode, usingScope);
    }

    @Override
    public boolean isAgg(SqlSelect select) {
        if (select.getOperand(4) != null) {
            return true;
        }
        if (select.getOperand(5) != null) {
            return true;
        }
        AggFinder.HasContainerAggCall call = new AggFinder.HasContainerAggCall();
        AggFinder aggFinder = new AggFinder(call);
        SqlNodeList selectItemList = select.getOperand(1).cast(SqlNodeList.class);
        for (SqlNode item : selectItemList) {
            item.accept(aggFinder);
        }
        return call.isAgg();
    }

    private void registerFrom(SqlNode node, String alias, SqlValidatorScope parentScope, SqlValidatorScope usingScope) {
        if (node.getKind() == SqlKind.AS) {
            String aliasName = this.alias(node);
            this.registerFrom(this.skipAlias(node), aliasName, parentScope, usingScope);
        } else if (node.getKind() == SqlKind.IDENTIFIER) {
            SqlIdentifier identifier = (SqlIdentifier)node;
            if (alias == null) {
                alias = identifier.getLast();
            }
            TableNamespace ns = new TableNamespace((SqlValidator)this, identifier);
            usingScope.addChild(alias, ns);
            this.registerNamespace(identifier, ns);
        } else if (node.getKind() == SqlKind.JOIN) {
            if (this.config.isValidateSqlWithJoin() && ++this.joinCount > this.config.getValidateSqlWithJoinCount()) {
                throw Exceptions.of((ErrorCode)ErrorCode.SqlValidateError2, (Object[])new Object[]{this.config.getValidateSqlWithJoinCount()});
            }
            SqlJoin sqlJoin = (SqlJoin)node;
            JoinScope joinScope = usingScope == null ? new JoinScope(parentScope, this, node, parentScope) : new JoinScope(parentScope, this, node, usingScope);
            this.scopes.put(node, joinScope);
            this.registerFrom(sqlJoin.getOperand(0), null, parentScope, joinScope);
            this.registerFrom(sqlJoin.getOperand(3), null, parentScope, joinScope);
            JoinNamespace joinNamespace = new JoinNamespace((SqlValidator)this, sqlJoin);
            this.registerNamespace(sqlJoin, joinNamespace);
        } else if (node.getKind().isBelong(SqlKind.TOP_LEVEL)) {
            if (alias == null) {
                throw Exceptions.of((ErrorCode)ErrorCode.SyntaxError_SubQueryRequireAlias, (SqlParserPosition)node.getPosition(), (Object[])new Object[0]);
            }
            this.registerQuery(node, parentScope, null, null);
            if (node.getKind().isBelong(SqlKind.SET_OP)) {
                SetopNamespace ns = (SetopNamespace)this.namespaces.get(node);
                usingScope.addChild(alias, ns);
            } else {
                SelectNamespace ns = (SelectNamespace)this.namespaces.get(node);
                usingScope.addChild(alias, ns);
            }
        } else {
            throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedKeyword, (SqlParserPosition)node.getPosition(), (Object[])new Object[]{node.getKind().name()});
        }
    }

    private void registerClauseScope(SqlNode node, SqlClause clause, SqlValidatorScope scope) {
        this.clauseScopes.put(IdPair.of(node, clause), scope);
    }

    private void registerNamespace(SqlNode node, SqlValidatorNamespace namespace) {
        this.namespaces.put(node, namespace);
    }

    private String alias(SqlNode sqlNode) {
        assert (sqlNode instanceof SqlBasicCall);
        assert (((SqlBasicCall)sqlNode).getOperand(1) instanceof SqlIdentifier);
        return ((SqlIdentifier)((SqlBasicCall)sqlNode).getOperand(1)).getSimple();
    }

    private SqlNode skipAlias(SqlNode sqlNode) {
        if (sqlNode.getKind() == SqlKind.AS) {
            SqlBasicCall basicCall = (SqlBasicCall)sqlNode;
            return basicCall.getOperand(0);
        }
        return sqlNode;
    }

    @Override
    public DataType getValidateNodeType(SqlNode node) {
        if (node.getKind() == SqlKind.AS) {
            SqlBasicCall basicCall = (SqlBasicCall)node;
            return this.nodeTypes.get(basicCall.getOperand(0));
        }
        return this.nodeTypes.get(node);
    }

    @Override
    public void setValidateNodeType(SqlNode sqlNode, DataType dataType) {
        if (dataType.getTypeName() == SqlTypeName.UNKNOWN) {
            return;
        }
        if (sqlNode.getKind() == SqlKind.AS) {
            this.nodeTypes.put(sqlNode.cast(SqlCall.class).getOperand(0), dataType);
        }
        this.nodeTypes.put(sqlNode, dataType);
    }

    private void validateNamespace(SqlValidatorNamespace namespace) {
        namespace.validate();
        this.setValidateNodeType(namespace.getSqlNode(), namespace.getDataType());
    }

    @Override
    public void validateQuery(SqlNode sqlNode, SqlValidatorScope scope) {
        SqlValidatorNamespace ns = this.getNamespace(sqlNode);
        this.validateNamespace(ns);
    }

    @Override
    public void validateSqlSelect(SqlSelect select) {
        if (select.getOperand(2) == null) {
            this.validateOneScalarExpression(select);
            return;
        }
        ListScope selectScope = this.scopes.get(select).wrapper(ListScope.class);
        assert (selectScope != null);
        List<String> nameList = selectScope.getChildrenNameList();
        Assertions.requireNonDuplicate(nameList, (list, index, duplicateIndex) -> {
            throw Exceptions.of((ErrorCode)ErrorCode.TableNameDuplicate, (Object[])new Object[]{list.get(index)});
        });
        this.validateFrom(select);
        this.validateSelectWithWhereOrLimit(select);
        this.validateWhere(select);
        this.validateGroupBy(select);
        this.validateHaving(select);
        this.validateOffsetLimit(select.getOperand(8), select.getOperand(9));
        DataType dataType = this.validateSelectList(select);
        SqlValidatorNamespace namespace = this.getNamespace(select);
        namespace.setDataType(dataType);
        this.validateOrderBy(select);
    }

    private void validateSelectWithWhereOrLimit(SqlSelect select) {
        TableNamespace namespace;
        FormAttribute formAttribute;
        SqlNode fromNode = select.getOperand(2);
        if (this.config.isValidateSqlWithWhereOrLimit() && fromNode != null && fromNode.getKind() == SqlKind.IDENTIFIER && (formAttribute = (namespace = (TableNamespace)this.namespaces.get(fromNode)).getTable().getFormAttribute()) != null && formAttribute.isBillForm()) {
            SqlNode whereNode = select.getOperand(3);
            SqlNode limitNode = select.getOperand(9);
            if (whereNode == null && limitNode == null) {
                throw Exceptions.of((ErrorCode)ErrorCode.SqlValidateError, (SqlParserPosition)select.getPosition(), (Object[])new Object[]{select.toSql()});
            }
        }
    }

    @Override
    public void validateSqlShow(SqlShow show) {
        ListScope showScope = this.scopes.get(show).wrapper(ListScope.class);
        TableNamespace ns = (TableNamespace)this.namespaces.get(show);
        if (this.authorityValidator != null) {
            if (show.getKind() == SqlKind.SHOW_TABLES) {
                if (show.getOperand(0) == null) {
                    SchemaUtils.getCurrentSchemaOnContext();
                    this.authorityValidator.validateSchema(PrivilegeType.of((PrivilegeType[])new PrivilegeType[]{PrivilegeType.DICT_SELECT}));
                } else {
                    String schemaCondition = ((SqlIdentifier)show.getOperand(0)).getSimple();
                    this.authorityValidator.validateSchema(schemaCondition.toLowerCase(Locale.ENGLISH), PrivilegeType.of((PrivilegeType[])new PrivilegeType[]{PrivilegeType.DICT_SELECT}));
                    ((MetadataTable)ns.getTable()).setSchemaCondition(schemaCondition);
                }
            }
            if (show.getKind() == SqlKind.SHOW_COLUMNS) {
                List<String> tableNames = ((SqlIdentifier)show.getOperand(0)).getNames();
                Table table = this.getSchemaReader().resolvedTable(tableNames);
                this.authorityValidator.validateSchema(table.fullyQualityName().get(0), PrivilegeType.of((PrivilegeType[])new PrivilegeType[]{PrivilegeType.DICT_SELECT}));
                this.authorityValidator.validateTable(Contexts.get().getCurrentDatabase(), table.fullyQualityName().get(0).toLowerCase(Locale.ENGLISH), Collections.singletonList(table.fullyQualityName().get(1).split("\\.")[0].toLowerCase(Locale.ENGLISH)));
                ((MetadataTable)ns.getTable()).setTable(table);
            }
        }
        Optional.ofNullable(show.getOperand(1)).ifPresent(where -> {
            ExpressionValidator expressionValidator = new ExpressionValidator(showScope, SqlKind.AGGREGATE_FUNCTIONS, SqlClause.WHERE);
            SqlNode newNode = expressionValidator.validate((SqlNode)where);
            newNode.validate(this, showScope);
            if (newNode != where) {
                show.setOperand(1, newNode);
            }
            this.inferUnknownType(this.dataTypeFactory.buildBoolean(), showScope, newNode);
            DataType type = this.inferDataTypeImpl(newNode, showScope);
            if (type.getTypeName() != SqlTypeName.BOOLEAN) {
                throw Exceptions.of((ErrorCode)ErrorCode.WhereClauseRequireBoolExpression, (Object[])new Object[0]);
            }
        });
    }

    @Override
    public void validateSqlUse(SqlUse use) {
        if (this.authorityValidator != null) {
            List<String> names = use.getNames();
            if (names.size() > 1) {
                this.authorityValidator.validateSchema(names.get(0).toLowerCase(Locale.ENGLISH), names.get(1).toLowerCase(Locale.ENGLISH), PrivilegeType.of((PrivilegeType[])new PrivilegeType[]{PrivilegeType.DICT_SELECT}));
            } else if (names.size() == 1) {
                this.authorityValidator.validateSchema(names.get(0).toLowerCase(Locale.ENGLISH), PrivilegeType.of((PrivilegeType[])new PrivilegeType[]{PrivilegeType.DICT_SELECT}));
            }
        }
        try {
            if (ExecutorManager.getSupplier(use.getKind()) == null) {
                ExecutorSupplier executorSupplier = (ExecutorSupplier)Class.forName(this.config.getUseSchemaExecutorSupplierClassName()).newInstance();
                ExecutorManager.register(use.getKind(), executorSupplier);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw Exceptions.of((ErrorCode)ErrorCode.ServerError_ExecutorRegisterFail, (Object[])new Object[]{e.getMessage()});
        }
    }

    @Override
    public void validateSqlShowVariables(SqlShowVariables sqlShowVariables) {
    }

    @Override
    public void validateSqlSetVariable(SqlSetVariable sqlSetVariable) {
        SqlLiteral key = sqlSetVariable.getOperand(SqlSetVariable.KEY_OPERAND).cast(SqlLiteral.class);
        String stringKey = ((String)key.getValue()).trim();
        if (stringKey.isEmpty()) {
            throw Exceptions.of((ErrorCode)ErrorCode.SetVariableErrorKeyNotExists, (Object[])new Object[]{key.getValue()});
        }
        if (!allowSetVariables.contains(stringKey)) {
            throw Exceptions.of((ErrorCode)ErrorCode.SetVariableErrorKeyNotAllowSet, (Object[])new Object[]{key.getValue()});
        }
    }

    @Override
    public void validateBasicCall(SqlCall call) {
        if (call.getOperator() instanceof SqlSetOperator) {
            SqlValidatorNamespace setOpNamespace = this.namespaces.get(call);
            setOpNamespace.validate();
        }
    }

    private void validateOneScalarExpression(SqlSelect select) {
        SqlNodeList selectList = select.getOperand(1).cast(SqlNodeList.class);
        ArrayList<String> nameList = new ArrayList<String>(selectList.size());
        ArrayList<DataType> typeList = new ArrayList<DataType>(selectList.size());
        EmptyScope scope = new EmptyScope(this, select);
        SqlNodeList newSelectList = new SqlNodeList(selectList.getPosition());
        ExpressionValidator expressionValidator = new ExpressionValidator(scope, SqlKind.AGGREGATE_FUNCTIONS, SqlClause.SELECT_LIST, false, false);
        for (int i = 0; i < selectList.size(); ++i) {
            SqlNode item = selectList.get(i);
            SqlNode item1 = expressionValidator.validate(item);
            this.inferUnknownType(this.dataTypeFactory.buildUnknownType(), scope, item1);
            typeList.add(this.inferDataType(item1, scope));
            nameList.add(SqlValidateUtil.getAlias(item1, i));
            newSelectList.add(item1);
        }
        select.setOperand(1, newSelectList);
        TupleDataType dataType = new TupleDataType("SELECT:" + select.hashCode(), nameList, typeList);
        SqlValidatorNamespace namespace = this.getNamespace(select);
        namespace.setDataType(dataType);
    }

    private void validateFrom(SqlSelect select) {
        if (select.getOperand(2) == null) {
            return;
        }
        SqlNode newFrom = this.validateFrom0(select.getOperand(2));
        select.setOperand(2, newFrom);
    }

    private SqlNode validateFrom0(SqlNode sqlNode) {
        if (sqlNode == null) {
            return null;
        }
        if (sqlNode.getKind() == SqlKind.AS) {
            SqlCall call = (SqlCall)sqlNode;
            SqlNode newOperand = this.validateFrom0(call.getOperand(0));
            if (!newOperand.equals(call.getOperand(0))) {
                call.setOperand(0, newOperand);
            }
            return call;
        }
        if (sqlNode.getKind() == SqlKind.IDENTIFIER) {
            TableNamespace ns = (TableNamespace)this.namespaces.get(sqlNode);
            ns.validate();
            SqlIdentifier newIdentifier = new SqlIdentifier(sqlNode.getPosition(), ns.fullyQualityName());
            this.namespaces.remove(sqlNode);
            this.registerNamespace(newIdentifier, ns);
            if (!newIdentifier.getLast().equals("$$inner_virtual_table$$") && this.authorityValidator != null) {
                this.authorityValidator.validateSchema(newIdentifier.getNames().get(0).toLowerCase(Locale.ENGLISH), PrivilegeType.of((PrivilegeType[])new PrivilegeType[]{PrivilegeType.DATA_SELECT}));
                this.authorityValidator.validateTable(Contexts.get().getCurrentDatabase(), newIdentifier.getNames().get(0).toLowerCase(Locale.ENGLISH), Collections.singletonList(newIdentifier.getNames().get(1).split("\\.")[0].toLowerCase(Locale.ENGLISH)));
            }
            return newIdentifier;
        }
        if (sqlNode.getKind() == SqlKind.JOIN) {
            SqlJoin sqlJoin = (SqlJoin)sqlNode;
            SqlNode leftOperand = this.validateFrom0(sqlJoin.getOperand(0));
            SqlNode rightOperand = this.validateFrom0(sqlJoin.getOperand(3));
            sqlJoin.setOperand(0, leftOperand);
            sqlJoin.setOperand(3, rightOperand);
            SqlValidatorScope joinScope = this.scopes.get(sqlJoin);
            SqlValidatorNamespace joinNamespace = this.getNamespace(sqlJoin);
            joinNamespace.validate();
            SqlNode conditionType = sqlJoin.getOperand(2);
            if (SqlConditionType.USING.symbol(SqlParserPosition.ZERO).equals(conditionType)) {
                throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedKeyword, (Object[])new Object[]{"USING"});
            }
            SqlNode condition = sqlJoin.getOperand(4);
            if (condition != null) {
                JoinExpressionValidator expressionValidator = new JoinExpressionValidator(joinScope);
                SqlNode newCondition = expressionValidator.validate(condition);
                newCondition.validate(this, joinScope);
                this.inferUnknownType(this.dataTypeFactory.buildBoolean(), joinScope, newCondition);
                DataType type = this.inferDataTypeImpl(newCondition, joinScope);
                if (type.getTypeName() != SqlTypeName.BOOLEAN) {
                    throw Exceptions.of((ErrorCode)ErrorCode.JoinCriteriaRequireBoolExpression, (SqlParserPosition)condition.getPosition(), (Object[])new Object[0]);
                }
                sqlJoin.setOperand(4, newCondition);
            }
            return sqlNode;
        }
        if (sqlNode.isBelong(SqlKind.SET_OP)) {
            this.validateBasicCall((SqlCall)sqlNode);
            return sqlNode;
        }
        if (sqlNode.isBelong(SqlKind.TOP_LEVEL)) {
            this.validateSqlSelect((SqlSelect)sqlNode);
            return sqlNode;
        }
        throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedFeature, (SqlParserPosition)sqlNode.getPosition(), (Object[])new Object[]{sqlNode.getKind().name()});
    }

    private void inferUnknownType(DataType inferredType, SqlValidatorScope scope, SqlNode node) {
        block5: {
            block6: {
                block4: {
                    if (!(node instanceof SqlDynamicParam) && !this.isNullLiteral(node)) break block4;
                    if (inferredType.getTypeName() == SqlTypeName.UNKNOWN) {
                        throw Exceptions.of((ErrorCode)ErrorCode.DynamicParamUnknownType, (SqlParserPosition)node.getPosition(), (Object[])new Object[0]);
                    }
                    this.setValidateNodeType(node, inferredType);
                    break block5;
                }
                if (!(node instanceof SqlNodeList)) break block6;
                SqlNodeList list = node.cast(SqlNodeList.class);
                for (SqlNode sqlNode : list) {
                    this.inferUnknownType(inferredType, scope, sqlNode);
                }
                break block5;
            }
            if (!(node instanceof SqlBasicCall)) break block5;
            SqlBasicCall basicCall = node.cast(SqlBasicCall.class);
            List<SqlNode> operands = basicCall.getOperandList();
            DataType[] operandTypes = new DataType[operands.size()];
            OperandTypeInference operandTypeInference = basicCall.getOperator().getOperandTypeInference();
            if (operandTypeInference != null) {
                operandTypeInference.inferOperandType(this, scope, basicCall, inferredType, operandTypes);
                for (int i = 0; i < operands.size(); ++i) {
                    this.inferUnknownType(operandTypes[i], scope, operands.get(i));
                }
            }
        }
    }

    private boolean isNullLiteral(SqlNode sqlNode) {
        if (sqlNode instanceof SqlLiteral) {
            this.setValidateNodeType(sqlNode, ((SqlLiteral)sqlNode).getDataType());
            SqlLiteral literal = sqlNode.cast(SqlLiteral.class);
            if (literal.getDataType().getTypeName() == SqlTypeName.NULL) {
                return true;
            }
            return literal.getValue() == null;
        }
        return false;
    }

    private void validateWhere(SqlSelect select) {
        if (select.getOperand(3) == null) {
            return;
        }
        SqlValidatorScope scope = this.getClauseScope(select, SqlClause.WHERE);
        SqlNode where = select.getOperand(3);
        ExpressionValidator expressionValidator = new ExpressionValidator(scope, SqlKind.AGGREGATE_FUNCTIONS, SqlClause.WHERE);
        SqlNode newNode = expressionValidator.validate(where);
        newNode.validate(this, scope);
        if (newNode != where) {
            select.setOperand(3, newNode);
        }
        this.inferUnknownType(this.dataTypeFactory.buildBoolean(), scope, newNode);
        DataType type = this.inferDataTypeImpl(newNode, scope);
        if (type.getTypeName() != SqlTypeName.BOOLEAN) {
            throw Exceptions.of((ErrorCode)ErrorCode.WhereClauseRequireBoolExpression, (SqlParserPosition)where.getPosition(), (Object[])new Object[0]);
        }
    }

    private void validateGroupBy(SqlSelect select) {
        if (select.getOperand(4) == null) {
            return;
        }
        SqlValidatorScope scope = this.getClauseScope(select, SqlClause.GROUP_BY);
        SqlNode groupBy = select.getOperand(4);
        ExpressionValidator expressionValidator = new ExpressionValidator(scope, SqlKind.concat(new Object[]{SqlKind.AGGREGATE_FUNCTIONS, SqlKind.TOP_LEVEL, SqlKind.DYNAMIC_PARAM}), SqlClause.WHERE);
        SqlNode newNode = expressionValidator.validate(groupBy);
        if (newNode != groupBy) {
            select.setOperand(4, newNode);
        }
        this.inferUnknownType(this.dataTypeFactory.buildUnknownType(), scope, newNode);
        SqlNodeList list = newNode.cast(SqlNodeList.class);
        for (SqlNode orderItem : list) {
            this.inferDataTypeImpl(orderItem, scope);
        }
    }

    private void validateHaving(SqlSelect select) {
        if (select.getOperand(5) == null) {
            return;
        }
        SqlValidatorScope scope = this.getClauseScope(select, SqlClause.HAVING);
        SqlNode having = select.getOperand(5);
        AggExpressionValidator aggExpressionValidator = new AggExpressionValidator(scope, (SqlNodeList)select.getOperand(4), SqlClause.HAVING);
        SqlNode newNode = aggExpressionValidator.validate(having);
        if (newNode != having) {
            select.setOperand(5, newNode);
        }
        this.inferUnknownType(this.dataTypeFactory.buildBoolean(), scope, newNode);
        DataType type = this.inferDataTypeImpl(newNode, scope);
        if (type.getTypeName() != SqlTypeName.BOOLEAN) {
            throw Exceptions.of((ErrorCode)ErrorCode.HavingClauseRequireBoolExpression, (SqlParserPosition)having.getPosition(), (Object[])new Object[0]);
        }
    }

    private void validateOffsetLimit(SqlNode offset, SqlNode limit) {
        SqlLiteral literal;
        if (offset instanceof SqlDynamicParam) {
            this.setValidateNodeType(offset, DataTypeFactory.instance.buildInt());
        } else if (offset != null) {
            if (!(offset instanceof SqlLiteral)) {
                throw Exceptions.of((ErrorCode)ErrorCode.OffsetRequireNumberLiteral, (SqlParserPosition)offset.getPosition(), (Object[])new Object[0]);
            }
            literal = (SqlLiteral)offset;
            if (literal.getDataType().getTypeName() != SqlTypeName.INT) {
                throw Exceptions.of((ErrorCode)ErrorCode.OffsetRequireIntLiteral, (SqlParserPosition)offset.getPosition(), (Object[])new Object[0]);
            }
        }
        if (limit instanceof SqlDynamicParam) {
            this.setValidateNodeType(limit, DataTypeFactory.instance.buildInt());
        } else if (limit != null) {
            if (!(limit instanceof SqlLiteral)) {
                throw Exceptions.of((ErrorCode)ErrorCode.LimitRequireNumberLiteral, (SqlParserPosition)limit.getPosition(), (Object[])new Object[0]);
            }
            literal = (SqlLiteral)limit;
            if (literal.getDataType().getTypeName() != SqlTypeName.INT) {
                throw Exceptions.of((ErrorCode)ErrorCode.LimitRequireIntLiteral, (SqlParserPosition)limit.getPosition(), (Object[])new Object[0]);
            }
        }
    }

    private DataType validateSelectList(SqlSelect select) {
        SqlNodeList list = (SqlNodeList)select.getOperand(1);
        SqlValidatorScope scope = this.scopes.get(select);
        ExpressionValidator expressionValidator = new ExpressionValidator(scope, null, SqlClause.SELECT_LIST, true, true);
        if (scope instanceof AggregateSelectScope) {
            expressionValidator = new AggExpressionValidator(scope, (SqlNodeList)select.getOperand(4), SqlClause.SELECT_LIST);
        }
        SqlNodeList newSelectList = new SqlNodeList(list.getPosition());
        ArrayList<String> nameList = new ArrayList<String>(list.size());
        ArrayList<DataType> typeList = new ArrayList<DataType>(list.size());
        HashMap<String, AtomicInteger> rename = new HashMap<String, AtomicInteger>();
        for (int i = 0; i < list.size(); ++i) {
            String name;
            SqlNode sqlNode = list.get(i);
            SqlNode expanderNode = this.expanderSelectItem(sqlNode, expressionValidator, scope, null, i);
            if (expanderNode instanceof SqlNodeList) {
                SqlNodeList expandList = (SqlNodeList)expanderNode;
                for (SqlNode node : expandList) {
                    SqlIdentifier identifier = (SqlIdentifier)node;
                    String name2 = identifier.getLast();
                    this.addSelectListName(nameList, rename, name2);
                    newSelectList.add(node);
                }
                continue;
            }
            if (expanderNode instanceof SqlIdentifier) {
                SqlIdentifier identifier = (SqlIdentifier)expanderNode;
                name = sqlNode.cast(SqlIdentifier.class).getLast();
                this.addSelectListName(nameList, rename, name);
                newSelectList.add(expanderNode);
                continue;
            }
            if (expanderNode.getKind() == SqlKind.AS) {
                SqlBasicCall basicCall = (SqlBasicCall)expanderNode;
                name = ((SqlIdentifier)basicCall.getOperand(1)).getLast();
                this.addSelectListName(nameList, rename, name);
                newSelectList.add(expanderNode);
                continue;
            }
            throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedFeature, (SqlParserPosition)sqlNode.getPosition(), (Object[])new Object[]{sqlNode.getKind()});
        }
        for (SqlNode sqlNode : newSelectList) {
            this.inferUnknownType(this.dataTypeFactory.buildUnknownType(), scope, sqlNode);
            typeList.add(this.inferDataTypeImpl(sqlNode, scope));
        }
        select.setOperand(1, newSelectList);
        return new TupleDataType("SELECT:" + select.hashCode(), nameList, typeList);
    }

    private void addSelectListName(List<String> nameList, Map<String, AtomicInteger> rename, String name) {
        AtomicInteger nameCount = rename.computeIfAbsent(name, k -> new AtomicInteger(0));
        if (nameCount.get() == 0) {
            nameList.add(name);
            nameCount.incrementAndGet();
        } else {
            nameList.add(name + nameCount.getAndIncrement());
        }
    }

    private SqlNode expanderSelectItem(SqlNode sqlNode, ExpressionValidator expressionValidator, SqlValidatorScope scope, String alias, int i) {
        if (sqlNode.getKind() == SqlKind.IDENTIFIER) {
            SqlIdentifier identifier = (SqlIdentifier)sqlNode;
            if (identifier.isStar()) {
                SqlNode expandNode = scope.expanderStar(identifier);
                return expressionValidator.validate(expandNode);
            }
            return expressionValidator.validate(identifier);
        }
        if (sqlNode.getKind() == SqlKind.AS) {
            SqlBasicCall basicCall = (SqlBasicCall)sqlNode;
            SqlNode newNode = this.expanderSelectItem(basicCall.getOperand(0), expressionValidator, scope, ((SqlIdentifier)basicCall.getOperand(1)).getSimple(), i);
            return new SqlBasicCall(basicCall.getPosition(), basicCall.getKind(), basicCall.getOperator(), newNode, basicCall.getOperand(1));
        }
        if (sqlNode.getKind().isBelong(SqlKind.TOP_LEVEL)) {
            this.validateQuery(sqlNode, null);
            SqlSelect subQuery = sqlNode.cast(SqlSelect.class);
            SqlNodeList subQuerySelectList = subQuery.getOperand(1).cast(SqlNodeList.class);
            if (subQuerySelectList.size() > 1) {
                throw Exceptions.of((ErrorCode)ErrorCode.SelectListRequireScalarSubQuery, (SqlParserPosition)subQuery.getPosition(), (Object[])new Object[0]);
            }
            if (alias == null) {
                return new SqlBasicCall(sqlNode.getPosition(), SqlKind.AS, SqlOperators.of(SqlKind.AS), sqlNode, new SqlIdentifier(sqlNode.getPosition(), Lists.newArrayList((Object[])new String[]{SqlValidateUtil.getAlias(sqlNode, i)})));
            }
            return sqlNode;
        }
        SqlNode newNode = expressionValidator.validate(sqlNode);
        if (alias == null) {
            return new SqlBasicCall(newNode.getPosition(), SqlKind.AS, SqlOperators.of(SqlKind.AS), newNode, new SqlIdentifier(newNode.getPosition(), Lists.newArrayList((Object[])new String[]{SqlValidateUtil.getAlias(sqlNode, i)})));
        }
        return newNode;
    }

    private void validateOrderBy(SqlSelect select) {
        if (select.getOperand(7) == null) {
            return;
        }
        SqlNodeList list = (SqlNodeList)select.getOperand(7);
        SqlValidatorScope scope = this.scopes.get(select);
        ExpressionValidator expressionValidator = new ExpressionValidator(scope, SqlKind.TOP_LEVEL, SqlClause.ORDER_BY, false, false);
        if (scope instanceof AggregateSelectScope) {
            expressionValidator = new AggExpressionValidator(scope, (SqlNodeList)select.getOperand(4), SqlClause.SELECT_LIST);
        }
        ArrayList<SqlNode> newList = new ArrayList<SqlNode>(list.size());
        for (SqlNode sqlNode : list) {
            newList.add(expressionValidator.validate(sqlNode));
        }
        for (SqlNode sqlNode : newList) {
            this.inferUnknownType(this.dataTypeFactory.buildUnknownType(), scope, sqlNode);
            this.inferDataTypeImpl(sqlNode, scope);
        }
        select.setOperand(7, new SqlNodeList(list.getPosition(), newList));
    }

    @Override
    public SqlValidatorScope getScope(SqlNode node) {
        return this.scopes.get(node);
    }

    @Override
    public SqlValidatorScope getClauseScope(SqlNode node, SqlClause clause) {
        IdPair<SqlNode, SqlClause> key = IdPair.of(node, clause);
        return this.clauseScopes.get(key);
    }

    @Override
    public SqlValidatorNamespace getNamespace(SqlNode node) {
        if (node.getKind() == SqlKind.AS) {
            return this.namespaces.get(((SqlBasicCall)node).getOperand(0));
        }
        return this.namespaces.get(node);
    }

    @Override
    public SchemaReader getSchemaReader() {
        return this.schemaReader;
    }

    @Override
    public DataTypeFactory getTypeFactory() {
        return this.dataTypeFactory;
    }

    @Override
    public DataType inferDataType(SqlNode sqlNode, SqlValidatorScope scope) {
        Objects.requireNonNull(sqlNode, "sqlNode can not be null.");
        Objects.requireNonNull(scope, "scope can not be null");
        DataType result = this.nodeTypes.get(sqlNode);
        if (result != null) {
            return result;
        }
        SqlValidatorNamespace namespace = this.namespaces.get(sqlNode);
        if (namespace != null && namespace.getDataType() != null) {
            return namespace.getDataType();
        }
        return this.inferDataTypeImpl(sqlNode, scope);
    }

    private DataType inferDataTypeImpl(SqlNode sqlNode, SqlValidatorScope scope) {
        DataTypeInfer infer = new DataTypeInfer(this, scope);
        DataType type = sqlNode.accept(infer);
        this.setValidateNodeType(sqlNode, type);
        return type;
    }

    @Override
    public TypeCoercion getTypeCoercion() {
        return this.typeCoercion;
    }

    static {
        for (Option updateOnSessionOption : ServerConfig.getUpdateOnSessionOptions()) {
            allowSetVariables.add(updateOnSessionOption.key());
        }
    }

    public static class SubQueryValidator
    extends ASTTraver {
        private final SqlValidator sqlValidator;

        public SubQueryValidator(SqlValidator sqlValidator) {
            this.sqlValidator = sqlValidator;
        }

        @Override
        public SqlNode visitSqlOrderBy(SqlOrderBy node) {
            node.getOperand(0).accept(this);
            return node;
        }

        @Override
        public SqlNode visitSqlSelect(SqlSelect node) {
            this.sqlValidator.validateSqlSelect(node);
            return node;
        }
    }
}

