/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.validate.impl;

import java.util.ArrayList;
import java.util.List;
import kd.bos.flydb.core.schema.Table;
import kd.bos.flydb.core.sql.tree.SqlIdentifier;
import kd.bos.flydb.core.sql.tree.SqlShow;
import kd.bos.flydb.core.sql.type.DataType;
import kd.bos.flydb.core.sql.validate.SchemaReader;
import kd.bos.flydb.core.sql.validate.SqlValidator;
import kd.bos.flydb.core.sql.validate.impl.DelegateNamespace;

public class TableNamespace
extends DelegateNamespace {
    private List<String> tableName;
    private DataType dataType;
    private Table table;

    public TableNamespace(SqlValidator validator, SqlIdentifier sqlNode) {
        super(validator, sqlNode);
        this.tableName = new ArrayList<String>(sqlNode.getNames());
    }

    public TableNamespace(SqlValidator validator, SqlShow sqlNode) {
        super(validator, sqlNode);
        this.tableName = new ArrayList<String>();
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public void setTableName(List<String> tableName) {
        this.tableName.clear();
        this.tableName.addAll(tableName);
    }

    public void setTable(Table table) {
        this.table = table;
    }

    @Override
    public void validate() {
        if (this.dataType == null) {
            SchemaReader schemaReader = this.validator.getSchemaReader();
            schemaReader.setSqlNode(this.sqlNode);
            this.table = schemaReader.resolvedTable(this.tableName);
            this.dataType = this.table.getDataType();
            this.tableName = this.table.fullyQualityName();
        }
    }

    public List<String> fullyQualityName() {
        return new ArrayList<String>(this.tableName);
    }

    public Table getTable() {
        return this.table;
    }
}

