/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import kd.bos.flydb.common.exception.CoreException;
import kd.bos.flydb.common.exception.ExceptionUtil;

public class CloseableResource
implements AutoCloseable {
    private final Consumer<List<Throwable>> exceptionHandler;
    private final List<Throwable> exceptions = new ArrayList<Throwable>();
    private final List<AutoCloseable> resources = new ArrayList<AutoCloseable>();

    public CloseableResource(Consumer<List<Throwable>> exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public CloseableResource(Consumer<List<Throwable>> exceptionHandler, AutoCloseable ... resources) {
        this.exceptionHandler = exceptionHandler;
        for (AutoCloseable closeable : resources) {
            if (closeable == null) continue;
            this.resources.add(closeable);
        }
    }

    public void addCloseable(AutoCloseable closeable) {
        if (closeable != null) {
            this.resources.add(closeable);
        }
    }

    public void addException(Exception exception) {
        this.exceptions.add(exception);
    }

    public boolean isCauseException() {
        return this.exceptions.isEmpty();
    }

    public CoreException wrapFirstAsCoreException() {
        return ExceptionUtil.wrapAsException((Throwable)this.getFirst());
    }

    public Throwable getFirst() {
        if (this.isCauseException()) {
            return this.exceptions.get(0);
        }
        return null;
    }

    @Override
    public void close() {
        if (this.resources != null && !this.resources.isEmpty()) {
            for (AutoCloseable closeable : this.resources) {
                try {
                    closeable.close();
                }
                catch (Exception exception) {
                    this.exceptions.add(exception);
                }
            }
            if (this.exceptionHandler != null) {
                this.exceptionHandler.accept(this.exceptions);
            }
        }
    }
}

