/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class DirectedGraph<T> {
    private final Set<Vertex<T>> vertices = new HashSet<Vertex<T>>();
    private final IdentityHashMap<Vertex<T>, List<Edge<T>>> outEdgeMap = new IdentityHashMap();
    private final IdentityHashMap<Vertex<T>, List<Edge<T>>> inEdgeMap = new IdentityHashMap();

    public ImmutableList<Edge<T>> getOutEdgeList(Vertex<T> vertex) {
        List<Edge<T>> out = this.outEdgeMap.get(vertex);
        if (out == null) {
            return null;
        }
        return ImmutableList.copyOf(out);
    }

    public ImmutableList<Edge<T>> getInEdgeList(Vertex<T> vertex) {
        List<Edge<T>> out = this.inEdgeMap.get(vertex);
        if (out == null) {
            return null;
        }
        return ImmutableList.copyOf(out);
    }

    public ImmutableSet<Vertex<T>> getAllVertices() {
        return ImmutableSet.copyOf(this.vertices);
    }

    public boolean addVertex(Vertex<T> vertex) {
        return this.vertices.add(vertex);
    }

    public Edge<T> addEdge(Vertex<T> source, Vertex<T> target) {
        if (Objects.equals(source, target)) {
            throw new IllegalArgumentException("source equals target");
        }
        Objects.requireNonNull(source, "vertex require nonNull");
        Objects.requireNonNull(target, "vertex require nonNull");
        this.addVertex(source);
        this.addVertex(target);
        Edge<T> edge = this.getEdge(source, target);
        if (edge != null) {
            return edge;
        }
        edge = new Edge<T>(source, target);
        List outEdges = this.outEdgeMap.computeIfAbsent(source, k -> new ArrayList());
        outEdges.add(edge);
        List inEdges = this.inEdgeMap.computeIfAbsent(target, k -> new ArrayList());
        inEdges.add(edge);
        return edge;
    }

    public Edge<T> getEdge(Vertex<T> source, Vertex<T> target) {
        List<Edge<T>> edges = this.outEdgeMap.get(source);
        if (edges == null) {
            return null;
        }
        for (Edge<T> edge : edges) {
            if (!edge.getTarget().equals(target)) continue;
            return edge;
        }
        return null;
    }

    public void remove(Vertex<T> source, Vertex<T> target) {
        Edge<T> edge = this.getEdge(source, target);
        if (edge != null) {
            this.outEdgeMap.get(source).remove(edge);
            this.inEdgeMap.get(target).remove(edge);
        }
    }

    public void gc(Vertex<T> root) {
        ImmutableList<Edge<T>> rootIn = this.getInEdgeList(root);
        if (rootIn != null && !rootIn.isEmpty()) {
            throw new IllegalArgumentException("Require root vertex");
        }
        Objects.requireNonNull(root, "Root node is null");
        ArrayList<Edge<T>> reachableEdges = new ArrayList<Edge<T>>();
        HashSet<Vertex<T>> unreachable = new HashSet<Vertex<T>>(this.vertices);
        Object edges = this.getOutEdgeList(root);
        while (edges != null && !edges.isEmpty()) {
            reachableEdges.addAll((Collection<Edge<T>>)edges);
            ArrayList nextEachEdges = new ArrayList();
            for (Edge edge : edges) {
                ImmutableList tmp = this.getOutEdgeList(edge.getTarget());
                if (tmp == null || tmp.isEmpty()) continue;
                nextEachEdges.addAll(tmp);
            }
            edges = nextEachEdges;
        }
        for (Edge edge : reachableEdges) {
            unreachable.remove(edge.getSource());
            unreachable.remove(edge.getTarget());
        }
        for (Vertex vertex : unreachable) {
            List<Edge<T>> outList = this.outEdgeMap.get(vertex);
            if (outList != null && !outList.isEmpty()) {
                for (Edge<T> tEdge : outList) {
                    this.inEdgeMap.remove(tEdge.getTarget());
                }
            }
            this.inEdgeMap.remove(vertex);
            this.outEdgeMap.remove(vertex);
            this.vertices.remove(vertex);
        }
    }

    public String toString() {
        HashSet<Vertex<T>> vertexHashSet = new HashSet<Vertex<T>>();
        for (Vertex<T> vertex : this.vertices) {
            ImmutableList<Edge<T>> edges = this.getInEdgeList(vertex);
            if (edges != null && !edges.isEmpty()) continue;
            vertexHashSet.add(vertex);
        }
        Object[] roots = vertexHashSet.toArray(new Vertex[0]);
        Arrays.sort(roots);
        StringWriter writer = new StringWriter();
        writer.append("{");
        for (Object root : roots) {
            writer.append("[");
            Object edges = this.getOutEdgeList((Vertex<T>)root);
            ArrayList<Edge<Object>> collect = new ArrayList<Edge<Object>>();
            if (edges != null && !edges.isEmpty()) {
                collect.addAll((Collection<Edge<Object>>)edges);
            }
            while (edges != null && !edges.isEmpty()) {
                ArrayList next = new ArrayList();
                for (Edge edge : edges) {
                    ImmutableList nextList = this.getOutEdgeList(edge.getTarget());
                    if (nextList == null) continue;
                    next.addAll(nextList);
                }
                edges = next;
                collect.addAll(next);
            }
            writer.append(collect.stream().map(Edge::toString).collect(Collectors.joining(",")));
            writer.append("]");
            if (root == roots[roots.length - 1]) continue;
            writer.append(",");
        }
        writer.append("}");
        return writer.toString();
    }

    public static class Edge<T> {
        private final Vertex<T> source;
        private final Vertex<T> target;

        public Edge(Vertex<T> source, Vertex<T> target) {
            this.source = source;
            this.target = target;
        }

        public Vertex<T> getSource() {
            return this.source;
        }

        public Vertex<T> getTarget() {
            return this.target;
        }

        public String toString() {
            return this.source + "->" + this.target;
        }
    }

    public static class Vertex<T>
    implements Comparable<Vertex<T>> {
        private final T node;

        public Vertex(T node) {
            this.node = node;
            Objects.requireNonNull(node, "vertex data require nonNull");
        }

        public T getNode() {
            return this.node;
        }

        public String toString() {
            return this.node.toString();
        }

        @Override
        public int compareTo(@NotNull Vertex o) {
            if (this.node instanceof Comparable) {
                return ((Comparable)this.node).compareTo(o.node);
            }
            return 0;
        }
    }
}

