/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.manager;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import kd.bos.algo.AlgoException;
import kd.bos.algox.AlgoXException;
import kd.bos.dc.api.model.Account;
import kd.bos.flydb.common.metadata.SchemaEntity;
import kd.bos.flydb.common.metadata.TableEntity;
import kd.bos.flydb.manager.SuperQueryService;
import kd.bos.flydb.manager.metadata.PrivilegeType;
import kd.bos.flydb.manager.mservice.FlyDBAuthService;
import kd.bos.flydb.manager.mservice.FlyDBAuthServiceImpl;
import kd.bos.flydb.manager.mservice.FlyDBSchemaService;
import kd.bos.flydb.manager.mservice.FlyDBSchemaServiceImpl;
import kd.bos.service.DispatchService;
import kd.bos.service.lookup.ServiceLookup;

public class SuperQueryServiceImpl
implements SuperQueryService {
    private final FlyDBAuthService authService = new FlyDBAuthServiceImpl();
    private final FlyDBSchemaService schemaService = new FlyDBSchemaServiceImpl();
    private static Method proveErpUserPassword;
    private static Method getErpUserInfoByPhone;

    private static DispatchService serviceLookup(String appId) {
        String serviceAppId = ServiceLookup.getServiceAppId((String)appId);
        return (DispatchService)ServiceLookup.lookup(DispatchService.class, (String)serviceAppId);
    }

    @Override
    public Map<String, String> userInfoMap(Account account, String phone, String language) {
        try {
            return (Map)getErpUserInfoByPhone.invoke(null, account, phone, language);
        }
        catch (Exception e) {
            throw new AlgoXException((Throwable)e);
        }
    }

    @Override
    public Long identify(Account account, String userNo, String password) {
        try {
            Map mapResult = (Map)proveErpUserPassword.invoke(null, account, userNo, password);
            if ("1".equals(mapResult.get("success"))) {
                return Long.valueOf((String)mapResult.get("userId"));
            }
        }
        catch (Exception e) {
            throw new AlgoXException((Throwable)e);
        }
        return null;
    }

    @Override
    public boolean check(Long userId, PrivilegeType[] privileges, String database, String schema) {
        return this.authService.check(userId, privileges, database, schema);
    }

    @Override
    public boolean exist(String database, String schema, String tableName) {
        return this.schemaService.exist(database, schema, tableName);
    }

    @Override
    public boolean exist(String database, String schema) {
        return this.schemaService.exist(database, schema);
    }

    @Override
    public List<String> list(String database, String schema) {
        return this.schemaService.list(database, schema);
    }

    @Override
    public List<TableEntity> listTables(String database, String schema) {
        return this.schemaService.listTables(database, schema);
    }

    @Override
    public List<String> listSchema(Long userId, String database) {
        return this.schemaService.listSchema(userId, database);
    }

    @Override
    public List<SchemaEntity> listSchemas(Long userId, String database) {
        return this.schemaService.listSchemas(userId, database);
    }

    static {
        try {
            Class<?> loginUserServiceClazz = Class.forName("kd.bos.login.user.LoginUserService");
            proveErpUserPassword = loginUserServiceClazz.getDeclaredMethod("proveErpUserPassword", Account.class, String.class, String.class);
            getErpUserInfoByPhone = loginUserServiceClazz.getDeclaredMethod("getErpUserInfoByPhone", Account.class, String.class, String.class);
        }
        catch (Exception e) {
            throw new AlgoException("reflect kd.bos.login.user.LoginUserService error.", (Throwable)e);
        }
    }
}

