/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.manager.mservice;

import java.util.ArrayList;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.flydb.manager.metadata.PrivilegeType;
import kd.bos.flydb.manager.metadata.SchemaPrivileges;
import kd.bos.flydb.manager.mservice.FlyDBAuthService;

public class FlyDBAuthServiceImpl
implements FlyDBAuthService {
    static final String QUERY_SQL = "select tfsp.fuserid, tfsp.fschemaid, tfsp.fid, tfsp.fauthitem from t_flydb_database tfd left join t_flydb_schema tfs on tfd.fid = tfs.fdatabaseid\nleft join t_flydb_schema_perm tfsp on tfsp.fschemaid  = tfs.fid\nwhere tfd.fnumber = ? and tfs.fnumber = ? and tfsp.fuserid = ? and tfs.fstatus = 'A'";

    @Override
    public boolean check(Long userId, PrivilegeType[] privileges, String database, String schema) {
        ArrayList ret = new ArrayList();
        DB.query((DBRoute)DBRoute.base, (String)QUERY_SQL, (Object[])new Object[]{database, schema, userId}, rs -> {
            while (rs.next()) {
                ret.add(new SchemaPrivileges(rs.getLong("fid"), rs.getLong("fschemaid"), rs.getLong("fuserid"), rs.getInt("fauthitem")));
            }
            return ret;
        });
        if (ret.size() == 0) {
            return false;
        }
        int authItem = ((SchemaPrivileges)ret.get(0)).getAuthItem();
        boolean pass = true;
        for (int i = 0; i < privileges.length; ++i) {
            int index = privileges[i].getKey();
            boolean bl = index == 0 ? (authItem & 1) == 1 : (pass = (authItem >> index & 1) == 1);
            if (!pass) break;
        }
        return pass;
    }
}

