/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.manager.mservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.flydb.common.metadata.SchemaEntity;
import kd.bos.flydb.common.metadata.TableEntity;
import kd.bos.flydb.manager.metadata.PrivilegeType;
import kd.bos.flydb.manager.mservice.FlyDBSchemaService;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class FlyDBSchemaServiceImpl
implements FlyDBSchemaService {
    static final String QUERY_SQL = "select tfs.fnumber,tfsp.fuserid, tfsp.fauthitem from t_flydb_database tfd left join t_flydb_schema tfs on tfd.fid = tfs.fdatabaseid left join t_flydb_schema_perm tfsp on tfsp.fschemaid = tfs.fid where tfd.fnumber = ? and tfsp.fuserid = ?";

    @Override
    public boolean exist(String database, String schema, String tableName) {
        QFilter filter = new QFilter("database.number", "=", (Object)database).and("number", "=", (Object)schema);
        DynamicObject schemaObj = QueryServiceHelper.queryOne((String)"bos_flydb_schema", (String)"id, tablestype", (QFilter[])filter.toArray());
        if (schemaObj == null) {
            return false;
        }
        String type = schemaObj.getString("tablestype");
        if ("1".equals(type)) {
            QFilter f = new QFilter("modeltype", "in", Arrays.asList("BaseFormModel", "BillFormModel")).and("number", "=", (Object)tableName);
            DynamicObjectCollection objects = QueryServiceHelper.query((String)"bos_flydb_objlist", (String)"id,number", (QFilter[])f.toArray(), (String)"number");
            return objects.size() > 0;
        }
        QFilter f = new QFilter("id", "=", (Object)schemaObj.getLong("id")).and("tables.fbasedataid.number", "=", (Object)tableName);
        DynamicObjectCollection objects = QueryServiceHelper.query((String)"bos_flydb_schema", (String)"id, tables.fbasedataid.id, tables.fbasedataid.name, tables.fbasedataid.number", (QFilter[])f.toArray());
        return objects.size() > 0;
    }

    @Override
    public boolean exist(String database, String schema) {
        QFilter filter = new QFilter("database.number", "=", (Object)database).and(new QFilter("number", "=", (Object)schema)).and(new QFilter("status", "=", (Object)"A"));
        DynamicObjectCollection objects = QueryServiceHelper.query((String)"bos_flydb_schema", (String)"id,number,tablestype", (QFilter[])filter.toArray());
        return objects.size() > 0;
    }

    @Override
    public List<String> list(String database, String schema) {
        DynamicObjectCollection objects;
        QFilter f;
        QFilter filter = new QFilter("database.number", "=", (Object)database).and("number", "=", (Object)schema);
        DynamicObject schemaObj = QueryServiceHelper.queryOne((String)"bos_flydb_schema", (String)"id, tablestype", (QFilter[])filter.toArray());
        if (schemaObj == null) {
            return new ArrayList<String>();
        }
        String type = schemaObj.getString("tablestype");
        if ("1".equals(type)) {
            f = new QFilter("modeltype", "in", Arrays.asList("BaseFormModel", "BillFormModel"));
            objects = QueryServiceHelper.query((String)"bos_flydb_objlist", (String)"id,number", (QFilter[])f.toArray(), (String)"number");
        } else {
            f = new QFilter("id", "=", (Object)schemaObj.getLong("id")).and(new QFilter("tables.fbasedataid.number", "is not null", null));
            objects = QueryServiceHelper.query((String)"bos_flydb_schema", (String)"id, tables.fbasedataid.id, tables.fbasedataid.name, tables.fbasedataid.number", (QFilter[])f.toArray());
        }
        ArrayList<String> tableList = new ArrayList<String>();
        for (DynamicObject dynamicObject : objects) {
            if ("1".equals(type)) {
                tableList.add(dynamicObject.getString("number"));
                continue;
            }
            tableList.add(dynamicObject.getString("tables.fbasedataid.number"));
        }
        return tableList;
    }

    @Override
    public List<TableEntity> listTables(String database, String schema) {
        DynamicObjectCollection objects;
        QFilter f;
        QFilter filter = new QFilter("database.number", "=", (Object)database).and("number", "=", (Object)schema);
        DynamicObject schemaObj = QueryServiceHelper.queryOne((String)"bos_flydb_schema", (String)"id, tablestype", (QFilter[])filter.toArray());
        if (schemaObj == null) {
            return new ArrayList<TableEntity>();
        }
        String type = schemaObj.getString("tablestype");
        if ("1".equals(type)) {
            f = new QFilter("modeltype", "in", Arrays.asList("BaseFormModel", "BillFormModel"));
            objects = QueryServiceHelper.query((String)"bos_flydb_objlist", (String)"id,number,name", (QFilter[])f.toArray(), (String)"number");
        } else {
            f = new QFilter("id", "=", (Object)schemaObj.getLong("id")).and(new QFilter("tables.fbasedataid.number", "is not null", null));
            objects = QueryServiceHelper.query((String)"bos_flydb_schema", (String)"id, tables.fbasedataid.id, tables.fbasedataid.name, tables.fbasedataid.number", (QFilter[])f.toArray());
        }
        ArrayList<TableEntity> tableList = new ArrayList<TableEntity>();
        for (DynamicObject dynamicObject : objects) {
            TableEntity entity = new TableEntity();
            if ("1".equals(type)) {
                entity.setNumber(dynamicObject.getString("number"));
                entity.setName(dynamicObject.getString("name"));
                entity.setType("entity");
            } else {
                entity.setNumber(dynamicObject.getString("tables.fbasedataid.number"));
                entity.setName(dynamicObject.getString("tables.fbasedataid.name"));
                entity.setType("entity");
            }
            tableList.add(entity);
        }
        return tableList;
    }

    @Override
    public List<String> listSchema(Long userId, String database) {
        ArrayList<String> schemaList = new ArrayList<String>();
        DB.query((DBRoute)DBRoute.base, (String)QUERY_SQL, (Object[])new Object[]{database, userId}, rs -> {
            while (rs.next()) {
                int authItem = rs.getInt("fauthitem");
                if ((authItem >> PrivilegeType.DICT_SELECT.getKey() & 1) != 1) continue;
                schemaList.add(rs.getString("fnumber"));
            }
            return schemaList;
        });
        return schemaList;
    }

    @Override
    public List<SchemaEntity> listSchemas(Long userId, String database) {
        ArrayList schemaList = new ArrayList();
        DB.query((DBRoute)DBRoute.base, (String)QUERY_SQL, (Object[])new Object[]{database, userId}, rs -> {
            while (rs.next()) {
                int authItem = rs.getInt("fauthitem");
                if ((authItem >> PrivilegeType.DICT_SELECT.getKey() & 1) != 1) continue;
                schemaList.add(rs.getString("fnumber"));
            }
            return schemaList;
        });
        if (schemaList.size() == 0) {
            return new ArrayList<SchemaEntity>();
        }
        ORM orm = ORM.create();
        QFilter qFilter = new QFilter("number", "in", (Object)schemaList.toArray()).and(new QFilter("status", "=", (Object)"A"));
        try (DataSet dataSet = orm.queryDataSet("flyDBSchemaService", "bos_flydb_schema", "number,name,type", qFilter.toArray());){
            Iterator iterator = dataSet.iterator();
            ArrayList<SchemaEntity> schemaEntities = new ArrayList<SchemaEntity>();
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                SchemaEntity entity = new SchemaEntity();
                entity.setNumber(row.getString("number"));
                entity.setName(row.getString("name"));
                entity.setType(row.getString("type"));
                schemaEntities.add(entity);
            }
            ArrayList<SchemaEntity> arrayList = schemaEntities;
            return arrayList;
        }
    }
}

