/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.starter;

import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.flydb.starter.ServiceStarter;
import kd.bos.flydb.starter.ServiceStarters;
import kd.bos.framework.lifecycle.Service;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class FlyDBService
implements Service {
    private static final Log log = LogFactory.getLog(FlyDBService.class);
    private static final String KEY = "flydb.service";
    private final AtomicBoolean starter = new AtomicBoolean();

    public String getName() {
        return "FlyDB";
    }

    public void start() {
        if (this.starter.compareAndSet(false, true)) {
            this.doStart();
        }
    }

    private void doStart() {
        String prop = System.getProperty(KEY);
        if (prop == null || prop.isEmpty()) {
            return;
        }
        String[] servicesArray = prop.split(",");
        HashSet<String> servicesNames = new HashSet<String>(servicesArray.length);
        for (String s : servicesArray) {
            servicesNames.add(s.trim().toLowerCase());
        }
        for (String serviceName : servicesNames) {
            ServiceStarter starter = ServiceStarters.create(serviceName);
            try {
                if (starter == null) continue;
                starter.start();
            }
            catch (Throwable throwable) {
                log.error("start flydb service: " + starter.getClass().getName() + " fail, " + throwable.getMessage(), throwable);
                throw throwable;
            }
        }
    }

    public void stop() {
    }

    public boolean isStarted() {
        return this.starter.get();
    }
}

