/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.starter;

import kd.bos.flydb.server.core.CoreService;
import kd.bos.flydb.server.session2.SessionCleanService;
import kd.bos.flydb.starter.ServiceStarter;
import kd.bos.service.register.ServiceRegister;

class RpcServerStarter
implements ServiceStarter {
    RpcServerStarter() {
    }

    @Override
    public void start() {
        CoreService.initMasterService();
        this.registerMasterAPI();
        this.registerDriverServerAPI();
        SessionCleanService.start();
    }

    private void registerMasterAPI() {
        StringBuilder rpcConfig = new StringBuilder();
        rpcConfig.append("interface=kd.bos.flydb.server.facade.MasterAPI\n").append("class=kd.bos.flydb.server.facade.MasterAPIImpl\n");
        String appIds = "flydb";
        String flyDBRegion = System.getProperty("flydb.region");
        if (flyDBRegion != null) {
            appIds = appIds + flyDBRegion;
        }
        rpcConfig.append("appIds=").append(appIds);
        ServiceRegister.registerService((String)"FlyDBMasterAPI", (String)rpcConfig.toString());
    }

    private void registerDriverServerAPI() {
        StringBuilder rpcConfig = new StringBuilder();
        rpcConfig.append("interface=kd.bos.flydb.server.facade.DriverServerAPI\n").append("class=kd.bos.flydb.server.facade.DriverServerAPIImpl\n");
        String appIds = "flydb";
        String flyDBRegion = System.getProperty("flydb.region");
        if (flyDBRegion != null) {
            appIds = appIds + flyDBRegion;
        }
        rpcConfig.append("appIds=").append(appIds);
        ServiceRegister.registerService((String)"FlyDBDriverServerAPI", (String)rpcConfig.toString());
    }
}

