/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.common;

import kd.bos.flydb.common.FlyDBConstants;
import kd.bos.flydb.common.ServerOption;
import kd.bos.flydb.common.SessionContextOption;
import kd.bos.flydb.common.config.ABCConfiguration;
import kd.bos.flydb.common.config.Configuration;
import kd.bos.flydb.common.config.LocalConfiguration;
import kd.bos.flydb.common.config.Option;
import kd.bos.flydb.common.config.RedisConfiguration;
import kd.bos.util.ConfigurationUtil;

public class ServerConfig {
    private static final LocalConfiguration configuration = new LocalConfiguration();
    private static final Option[] showOptions = new Option[]{ServerOption.AlgoXRegion, ServerOption.DiskCachePath, ServerOption.OutputPath, ServerOption.OutputBufferSize, ServerOption.OutputBatchCount, ServerOption.AlgoXRegion, ServerOption.SESSION_KEEPER_INTERVAL, ServerOption.FetchSize, ServerOption.QueryTimeout, ServerOption.EnableReadonlyFirst, ServerOption.SessionTimeout, ServerOption.AlgoXOutputMaxLifeTime, ServerOption.SqlOptimizeInVariable, ServerOption.SqlOptimizeInVariable2OrThreshold, ServerOption.SqlOptimizeInVariable2JoinThreshold, ServerOption.SqlOptimizeInVariableMaxSize, ServerOption.EnableRBO, ServerOption.EnableShardingTableInput, ServerOption.ForceSlaveDB, SessionContextOption.LanguageEnv};
    private static final Option[] updateOnSessionOptions = new Option[]{ServerOption.FetchSize, ServerOption.QueryTimeout, ServerOption.EnableReadonlyFirst, ServerOption.SessionTimeout, ServerOption.SqlOptimizeInVariable, ServerOption.SqlOptimizeInVariable2OrThreshold, ServerOption.SqlOptimizeInVariable2JoinThreshold, ServerOption.SqlOptimizeInVariableMaxSize, ServerOption.EnableRBO, ServerOption.EnableShardingTableInput, ServerOption.ForceSlaveDB, SessionContextOption.LanguageEnv};
    private static final Option[] sessionIgnoreOptions = new Option[]{ServerOption.ServiceKey, ServerOption.DiskCachePath, ServerOption.OutputPath, ServerOption.OutputBufferSize, ServerOption.OutputBatchCount};

    public static Configuration getSysConfiguration() {
        return configuration;
    }

    public static RedisConfiguration getSessionConfiguration(String sessionId) {
        return new RedisConfiguration(sessionId);
    }

    public static RedisConfiguration getStatementConfiguration(String sessionId, String stmtId) {
        return new RedisConfiguration(sessionId + '_' + stmtId);
    }

    public static ABCConfiguration getSessionABCConfiguration(String sessionId) {
        return new ABCConfiguration(ServerConfig.getSessionConfiguration(sessionId), ServerConfig.getSysConfiguration());
    }

    public static ABCConfiguration getStatementABCConfiguration(String sessionId, String stmtId) {
        return new ABCConfiguration(ServerConfig.getStatementConfiguration(sessionId, stmtId), ServerConfig.getSessionConfiguration(sessionId), ServerConfig.getSysConfiguration());
    }

    public static Option[] getShowOptions() {
        return showOptions;
    }

    public static Option[] getUpdateOnSessionOptions() {
        return updateOnSessionOptions;
    }

    public static Option[] getSessionIgnoreOptions() {
        return sessionIgnoreOptions;
    }

    static {
        configuration.setString(ServerOption.ServiceKey, ConfigurationUtil.getString((String)"flydb.service"));
        configuration.setString(ServerOption.AlgoXRegion, FlyDBConstants.getKeyWithRegion());
        configuration.setString(ServerOption.DiskCachePath, ConfigurationUtil.getString((String)"diskcache.path"));
        configuration.setString(ServerOption.OutputPath, ConfigurationUtil.getString((String)"flydb.output.path"));
        configuration.setInt(ServerOption.OutputBufferSize, ConfigurationUtil.getInteger((String)"flydb.output.bufferSize", (Integer)Integer.parseInt(ServerOption.OutputBufferSize.defaultValue())));
        configuration.setInt(ServerOption.OutputBatchCount, ConfigurationUtil.getInteger((String)"flydb.output.batchCount", (Integer)Integer.parseInt(ServerOption.OutputBatchCount.defaultValue())));
        ConfigurationUtil.observeString((String)"flydb.jdbc.authPlugin", (String)ServerOption.AuthPlugin.defaultValue(), v -> configuration.setString(ServerOption.AuthPlugin, (String)v));
        ConfigurationUtil.observeInteger((String)"flydb.sessionTimeout", (int)Integer.parseInt(ServerOption.SessionTimeout.defaultValue()), v -> configuration.setInt(ServerOption.SessionTimeout, (int)v));
        ConfigurationUtil.observeInteger((String)"flydb.fetchSize", (int)Integer.parseInt(ServerOption.FetchSize.defaultValue()), v -> configuration.setInt(ServerOption.FetchSize, (int)v));
        ConfigurationUtil.observeBoolean((String)"flydb.readonlyFirst", (boolean)Boolean.parseBoolean(ServerOption.EnableReadonlyFirst.defaultValue()), v -> configuration.setBool(ServerOption.EnableReadonlyFirst, (boolean)v));
        ConfigurationUtil.observeInteger((String)"flydb.queryTimeout", (int)Integer.parseInt(ServerOption.QueryTimeout.defaultValue()), v -> configuration.setInt(ServerOption.QueryTimeout, (int)v));
        ConfigurationUtil.observeInteger((String)"flydb.algoxOutputMaxLifeTime", (int)Integer.parseInt(ServerOption.AlgoXOutputMaxLifeTime.defaultValue()), v -> configuration.setInt(ServerOption.AlgoXOutputMaxLifeTime, (int)v));
        ConfigurationUtil.observeBoolean((String)"flydb.sqlOptimizeInVariable", (boolean)Boolean.parseBoolean(ServerOption.SqlOptimizeInVariable.defaultValue()), v -> configuration.setBool(ServerOption.SqlOptimizeInVariable, (boolean)v));
        ConfigurationUtil.observeInteger((String)"flydb.sqlOptimizeInVariable2OrThreshold", (int)Integer.parseInt(ServerOption.SqlOptimizeInVariable2OrThreshold.defaultValue()), v -> configuration.setInt(ServerOption.SqlOptimizeInVariable2OrThreshold, (int)v));
        ConfigurationUtil.observeInteger((String)"flydb.sqlOptimizeInVariable2JoinThreshold", (int)Integer.parseInt(ServerOption.SqlOptimizeInVariable2JoinThreshold.defaultValue()), v -> configuration.setInt(ServerOption.SqlOptimizeInVariable2JoinThreshold, (int)v));
        ConfigurationUtil.observeInteger((String)"flydb.sqlOptimizeInVariableMaxSize", (int)Integer.parseInt(ServerOption.SqlOptimizeInVariableMaxSize.defaultValue()), v -> configuration.setInt(ServerOption.SqlOptimizeInVariableMaxSize, (int)v));
        ConfigurationUtil.observeBoolean((String)"flydb.enableShardingTableInput", (boolean)Boolean.parseBoolean(ServerOption.EnableShardingTableInput.defaultValue()), v -> configuration.setBool(ServerOption.EnableShardingTableInput, (boolean)v));
        ConfigurationUtil.observeBoolean((String)"flydb.forceSlaveDB", (boolean)Boolean.parseBoolean(ServerOption.ForceSlaveDB.defaultValue()), v -> configuration.setBool(ServerOption.ForceSlaveDB, (boolean)v));
        ConfigurationUtil.observeInteger((String)"flydb.log.paramMaxLength", (int)Integer.parseInt(ServerOption.LogParamMaxLength.defaultValue()), v -> configuration.setInt(ServerOption.LogParamMaxLength, (int)v));
    }
}

