/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.common;

import kd.bos.flydb.common.FlyDBConstants;
import kd.bos.flydb.common.config.Option;
import kd.bos.flydb.common.config.OptionType;
import kd.bos.flydb.common.config.Options;

public enum ServerOption implements Option
{
    ServiceKey("flydb.service", OptionType.STRING, null, "Service of FlyDB, can not be null, e.g. flydb-server, flydb-worker, flydb-web"),
    DiskCachePath("diskcache.path", OptionType.STRING, null, "diskcache path, can not be null, global config"),
    OutputPath("flydb.output.path", OptionType.STRING, null, "output path, priority higher than DiskCachePath, global config"),
    OutputBufferSize("flydb.output.bufferSize", OptionType.INT, "65536", "output buffer size, default: 64k"),
    OutputBatchCount("flydb.output.batchCount", OptionType.INT, "5000", "output file index batch count, default: 5000"),
    AlgoXRegion("flydb.region", OptionType.STRING, FlyDBConstants.getKeyWithRegion(), "flydbregion"),
    SESSION_KEEPER_INTERVAL("flydb.session_keeper_interval", OptionType.INT, "60", "if client block, scanning invalid sessions in interval second, and fire close without timeout."),
    AuthPlugin("flydb.jdbc.authPlugin", OptionType.STRING, "native_password", "jdbc authorize plugin"),
    FetchSize("flydb.fetchSize", OptionType.INT, "5000", "jdbc default fetch size"),
    QueryTimeout("flydb.queryTimeout", OptionType.INT, "1800", "query timeout,default 1800 seconds"),
    EnableReadonlyFirst("flydb.readonlyFirst", OptionType.BOOLEAN, "true", "readonly first when query"),
    SessionTimeout("flydb.sessionTimeout", OptionType.INT, "28800", "if there is no read/write, the session will be closed after the timeout(second)."),
    AlgoXOutputMaxLifeTime("flydb.algoxOutputMaxLifeTime", OptionType.INT, "24", "algox output result max life time,default 48 hours"),
    SqlOptimizeInVariable("flydb.sqlOptimizeInVariable", OptionType.BOOLEAN, "true", "sql optimize at node of sub query or variable parameter"),
    SqlOptimizeInVariable2OrThreshold("flydb.sqlOptimizeInVariable2OrThreshold", OptionType.INT, "100", "sql optimize to or when variable parameter less then 2OrThreshold"),
    SqlOptimizeInVariable2JoinThreshold("flydb.sqlOptimizeInVariable2JoinThreshold", OptionType.INT, "1000", "sql optimize to join when variable parameter more then 2JoinThreshold"),
    SqlOptimizeInVariableMaxSize("flydb.sqlOptimizeInVariableMaxSize", OptionType.INT, "500000", "sql optimize max size at variable parameter"),
    EnableRBO("flydb.enableRBO", OptionType.BOOLEAN, "false", "enable rule-base-optimize for query planner"),
    EnableShardingTableInput("flydb.enableShardingTableInput", OptionType.BOOLEAN, "true", "enable sharding entity db input for combine"),
    ForceSlaveDB("flydb.forceSlaveDB", OptionType.BOOLEAN, "true", "force data query from slave db, otherwise throw an interrupt exception"),
    LogParamMaxLength("flydb.log.paramMaxLength", OptionType.INT, "1024", "the max length for log parameter");

    private final String key;
    private final OptionType type;
    private final String defaultValue;
    private final String desc;

    private ServerOption(String key, OptionType type, String defaultValue, String desc) {
        this.key = key;
        this.type = type;
        this.defaultValue = defaultValue;
        this.desc = desc;
        Options.register(key, this);
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public OptionType type() {
        return this.type;
    }

    @Override
    public String defaultValue() {
        return this.defaultValue;
    }

    @Override
    public String desc() {
        return this.desc;
    }
}

