/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.common.config;

import kd.bos.flydb.common.config.Configuration;
import kd.bos.flydb.common.config.Option;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;

public class ABCConfiguration
implements Configuration {
    private final Configuration[] configurations;

    public ABCConfiguration(Configuration ... configurations) {
        this.configurations = configurations;
    }

    @Override
    public void set(Option key, String value) {
        throw Exceptions.of(ErrorCode.ServerError_SetABCConfiguration, new Object[0]);
    }

    @Override
    public void setString(Option key, String value) {
        throw Exceptions.of(ErrorCode.ServerError_SetABCConfiguration, new Object[0]);
    }

    @Override
    public void setInt(Option key, int value) {
        throw Exceptions.of(ErrorCode.ServerError_SetABCConfiguration, new Object[0]);
    }

    @Override
    public String getString(Option key) {
        for (Configuration configuration : this.configurations) {
            String value = configuration.getString(key);
            if (value == null) continue;
            return value;
        }
        return key.defaultValue();
    }

    @Override
    public Integer getInt(Option key) {
        for (Configuration configuration : this.configurations) {
            Integer value = configuration.getInt(key);
            if (value == null) continue;
            return value;
        }
        return Integer.parseInt(key.defaultValue());
    }

    @Override
    public Long getLong(Option key) {
        for (Configuration configuration : this.configurations) {
            Long value = configuration.getLong(key);
            if (value == null) continue;
            return value;
        }
        return Long.parseLong(key.defaultValue());
    }

    @Override
    public void setLong(Option key, Long value) {
        throw Exceptions.of(ErrorCode.ServerError_SetABCConfiguration, new Object[0]);
    }

    @Override
    public void setBool(Option key, boolean value) {
        throw Exceptions.of(ErrorCode.ServerError_SetABCConfiguration, new Object[0]);
    }

    @Override
    public Boolean getBool(Option key) {
        for (Configuration configuration : this.configurations) {
            Boolean value = configuration.getBool(key);
            if (value == null) continue;
            return value;
        }
        return Boolean.parseBoolean(key.defaultValue());
    }

    @Override
    public String getAsString(Option key) {
        for (Configuration configuration : this.configurations) {
            String value = configuration.getAsString(key);
            if (value == null) continue;
            return value;
        }
        return key.defaultValue();
    }
}

