/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.common.config;

import java.util.IdentityHashMap;
import kd.bos.flydb.common.config.Configuration;
import kd.bos.flydb.common.config.Option;
import kd.bos.flydb.common.config.OptionType;

public class LocalConfiguration
implements Configuration {
    protected final IdentityHashMap<Option, Object> prop = new IdentityHashMap();

    @Override
    public void set(Option key, String value) {
        OptionType type = key.type();
        switch (type) {
            case STRING: {
                this.setString(key, value);
                break;
            }
            case LONG: {
                this.setLong(key, Long.parseLong(value));
                break;
            }
            case INT: {
                this.setInt(key, Integer.parseInt(value));
                break;
            }
            case BOOLEAN: {
                this.setBool(key, Boolean.parseBoolean(value));
                break;
            }
            default: {
                throw new UnknownError("unknown option type: " + (Object)((Object)type));
            }
        }
    }

    @Override
    public void setString(Option key, String value) {
        this.prop.put(key, value);
    }

    @Override
    public void setInt(Option key, int value) {
        this.prop.put(key, value);
    }

    @Override
    public String getString(Option key) {
        return (String)this.prop.get(key);
    }

    @Override
    public Integer getInt(Option key) {
        return (Integer)this.prop.get(key);
    }

    @Override
    public Long getLong(Option key) {
        return (Long)this.prop.get(key);
    }

    @Override
    public void setLong(Option key, Long value) {
        this.prop.put(key, value);
    }

    @Override
    public void setBool(Option key, boolean value) {
        this.prop.put(key, value);
    }

    @Override
    public Boolean getBool(Option key) {
        return (Boolean)this.prop.get(key);
    }

    @Override
    public String getAsString(Option key) {
        switch (key.type()) {
            default: {
                String stringValue = this.getString(key);
                if (stringValue == null) {
                    return null;
                }
                return stringValue;
            }
            case LONG: {
                Long longValue = this.getLong(key);
                if (longValue == null) {
                    return null;
                }
                return String.valueOf(longValue);
            }
            case INT: {
                Integer intValue = this.getInt(key);
                if (intValue == null) {
                    return null;
                }
                return String.valueOf(intValue);
            }
            case BOOLEAN: 
        }
        Boolean boolValue = this.getBool(key);
        if (boolValue == null) {
            return null;
        }
        return String.valueOf(boolValue);
    }
}

