/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.common.config;

import java.util.Objects;
import kd.bos.flydb.common.config.Configuration;
import kd.bos.flydb.common.config.Option;
import kd.bos.flydb.common.config.OptionType;
import kd.bos.flydb.common.util.RedisMap;

public class RedisConfiguration
implements Configuration {
    private final RedisMap storage;

    public RedisConfiguration(String sessionId) {
        Objects.requireNonNull(sessionId);
        this.storage = new RedisMap(RedisConfiguration.class.getName(), sessionId);
    }

    public void copyOption(Option key, Configuration configuration) {
        OptionType type = key.type();
        switch (type) {
            case STRING: {
                String value = configuration.getString(key);
                if (value == null) break;
                this.setString(key, value);
                break;
            }
            case LONG: {
                Long value = configuration.getLong(key);
                if (value == null) break;
                this.setLong(key, value);
                break;
            }
            case INT: {
                Integer value = configuration.getInt(key);
                if (value == null) break;
                this.setInt(key, value);
                break;
            }
            case BOOLEAN: {
                Boolean value = configuration.getBool(key);
                if (value == null) break;
                this.setBool(key, value);
                break;
            }
            default: {
                throw new UnknownError("unknown option type: " + (Object)((Object)type));
            }
        }
    }

    @Override
    public void set(Option key, String value) {
        OptionType type = key.type();
        switch (type) {
            case STRING: {
                this.setString(key, value);
                break;
            }
            case LONG: {
                this.setLong(key, Long.parseLong(value));
                break;
            }
            case INT: {
                this.setInt(key, Integer.parseInt(value));
                break;
            }
            case BOOLEAN: {
                this.setBool(key, Boolean.parseBoolean(value));
                break;
            }
            default: {
                throw new UnknownError("unknown option type: " + (Object)((Object)type));
            }
        }
    }

    @Override
    public void setString(Option key, String value) {
        this.storage.put(key.key(), value);
    }

    @Override
    public void setInt(Option key, int value) {
        this.setString(key, String.valueOf(value));
    }

    @Override
    public String getString(Option key) {
        return this.storage.get(key.key());
    }

    @Override
    public Integer getInt(Option key) {
        String value = this.getString(key);
        if (value == null) {
            return null;
        }
        return Integer.valueOf(value);
    }

    @Override
    public Long getLong(Option key) {
        String value = this.getString(key);
        if (value == null) {
            return null;
        }
        return Long.valueOf(value);
    }

    @Override
    public void setLong(Option key, Long value) {
        this.setString(key, String.valueOf(value));
    }

    @Override
    public void setBool(Option key, boolean value) {
        this.setString(key, String.valueOf(value));
    }

    @Override
    public Boolean getBool(Option key) {
        String value = this.getString(key);
        if (value == null) {
            return null;
        }
        return Boolean.valueOf(value);
    }

    @Override
    public String getAsString(Option key) {
        return this.getString(key);
    }

    public void release() {
        this.storage.release();
    }

    public void expire(long seconds) {
        this.storage.expire(seconds);
    }
}

