/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.common.exception;

import java.util.HashSet;
import kd.bos.flydb.common.exception.CoreException;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;

public final class ExceptionUtil {
    public static Throwable tryUnwrapCoreException(Throwable original) {
        if (original == null) {
            return Exceptions.of(ErrorCode.ServerError_UnexpectedException, "The original throwable is null");
        }
        if (original instanceof CoreException) {
            return original;
        }
        HashSet<Throwable> trace = new HashSet<Throwable>();
        trace.add(original);
        for (Throwable next = original.getCause(); next != null; next = next.getCause()) {
            if (trace.contains(next)) {
                return original;
            }
            trace.add(next);
            if (!(next instanceof CoreException)) continue;
            return next;
        }
        return original;
    }

    public static CoreException wrapAsException(Throwable throwable) {
        if (throwable instanceof CoreException) {
            return (CoreException)throwable;
        }
        if (throwable.getCause() instanceof CoreException) {
            throw (CoreException)throwable.getCause();
        }
        if (throwable instanceof NullPointerException) {
            throw Exceptions.of(ErrorCode.ServerError_UnexpectedException, "Null pointer exception occurred, please obtain detailed information from the log");
        }
        if (throwable.getCause() instanceof ClassCastException) {
            throw Exceptions.of(ErrorCode.ServerError_UnexpectedException, "ClassCastException occurred, please obtain detailed information from the log");
        }
        if (throwable instanceof UnsupportedOperationException) {
            throw Exceptions.of(ErrorCode.UnexpectedUnsupportedFeatureError, throwable.getMessage());
        }
        throw Exceptions.of(ErrorCode.ServerError_UnexpectedException1, new Object[0]);
    }
}

